/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.util;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitRequest;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.repository.NoDefaultBranchException;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.repository.ResolveRefRequest;
import com.atlassian.bitbucket.ui.PluginFormFragmentsFactory;
import com.atlassian.stash.internal.project.InternalProjectService;
import com.atlassian.stash.internal.scm.InternalScmService;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import com.atlassian.stash.internal.web.util.RepositoryControllerSupport;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;

public abstract class CompareControllerSupport
extends RepositoryControllerSupport {
    protected final CommitService commitService;
    protected final PluginFormFragmentsFactory fragmentsFactory;
    @Value(value="${page.max.changes}")
    protected int maxChanges;

    protected CompareControllerSupport(I18nService i18nService, RefService refService, PermissionService permissionService, InternalProjectService projectService, RepositoryService repositoryService, InternalScmService scmService, CommitService commitService, PluginFormFragmentsFactory fragmentsFactory) {
        super(i18nService, refService, permissionService, projectService, repositoryService, scmService);
        this.commitService = commitService;
        this.fragmentsFactory = fragmentsFactory;
    }

    protected StashSoyResponseBuilder getCompareViewBuilder(String view, Repository fromRepository, String fromBranch, Repository toRepository, String toBranch, String pluginFieldsContent) {
        Ref fromBranchRef = this.resolveFromRef(fromRepository, fromBranch);
        Commit sourceCommit = null;
        if (fromBranchRef != null) {
            sourceCommit = this.getCommit(fromRepository, fromBranchRef);
        }
        Ref toBranchRef = this.resolveToRef(toRepository, toBranch);
        Commit targetCommit = null;
        if (toBranchRef != null) {
            targetCommit = this.getCommit(toRepository, toBranchRef);
        }
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(view).put("pluginFieldsContent", (Object)pluginFieldsContent)).put("maxChanges", (Object)this.maxChanges)).put("sourceRepository", (Object)fromRepository)).putIfNotNull("sourceBranch", (Object)fromBranchRef).putIfNotNull("sourceCommit", (Object)sourceCommit).putIfNotNull("sourceBranchFailed", (Object)(fromBranchRef == null ? fromBranch : null)).put("targetRepository", (Object)toRepository)).putIfNotNull("targetBranch", (Object)toBranchRef).putIfNotNull("targetCommit", (Object)targetCommit).putIfNotNull("targetBranchFailed", (Object)(toBranchRef == null ? toBranch : null)).putRepository(toRepository);
    }

    protected StashSoyResponseBuilder getCompareViewBuilder(String view, Repository fromRepository, String fromBranch, Repository toRepository, String toBranch) {
        return this.getCompareViewBuilder(view, view, fromRepository, fromBranch, toRepository, toBranch);
    }

    protected StashSoyResponseBuilder getCompareViewBuilder(String view, String fragmentKey, Repository fromRepository, String fromBranch, Repository toRepository, String toBranch) {
        HashMap context = Maps.newHashMap();
        context.put("fromRepository", fromRepository);
        context.put("toRepository", toRepository);
        String pluginFieldsContent = this.fragmentsFactory.forKey(fragmentKey, (Map)context).getViewHtml();
        return this.getCompareViewBuilder(view, fromRepository, fromBranch, toRepository, toBranch, pluginFieldsContent);
    }

    protected void handleNullRef(Repository repository, String branch) {
    }

    private Commit getCommit(Repository repository, Ref ref) {
        return this.commitService.getCommit(new CommitRequest.Builder(repository, ref.getLatestCommit()).build());
    }

    private Ref resolveFromRef(Repository fromRepository, String fromBranch) {
        if (StringUtils.isBlank((CharSequence)fromBranch)) {
            return null;
        }
        Ref ref = this.refService.resolveRef(new ResolveRefRequest.Builder(fromRepository).refId(fromBranch).build());
        if (ref == null) {
            this.handleNullRef(fromRepository, fromBranch);
        }
        return ref;
    }

    private Ref resolveToRef(Repository toRepository, String toBranch) {
        toBranch = StringUtils.isBlank((CharSequence)toBranch) ? null : toBranch;
        Ref toBranchRef = null;
        try {
            toBranchRef = this.refService.resolveRef(new ResolveRefRequest.Builder(toRepository).refId(toBranch).build());
            if (toBranchRef == null) {
                this.handleNullRef(toRepository, toBranch);
            }
        }
        catch (NoDefaultBranchException e) {
            this.log.debug("No default branch set on {}/{}", (Object)toRepository.getProject().getKey(), (Object)toRepository.getSlug());
        }
        return toBranchRef;
    }
}

