/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.users;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.auth.CaptchaRequiredAuthenticationException;
import com.atlassian.bitbucket.auth.IncorrectPasswordAuthenticationException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.ui.PluginFormFragments;
import com.atlassian.bitbucket.ui.PluginFormFragmentsFactory;
import com.atlassian.bitbucket.ui.ValidationErrors;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.DetailedUser;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.stash.internal.auth.AuthenticationHelper;
import com.atlassian.stash.internal.crowd.CrowdControl;
import com.atlassian.stash.internal.plugin.PluginValidationErrors;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import com.atlassian.stash.internal.web.users.AccountPasswordForm;
import com.atlassian.stash.internal.web.users.AccountSettingsForm;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Controller;
import org.springframework.validation.Errors;
import org.springframework.validation.beanvalidation.SpringValidatorAdapter;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@RequestMapping(value={"/account"})
public class UserAccountController {
    @VisibleForTesting
    static final String SETTINGS_VIEW = "bitbucket.internal.users.account.settings";
    @VisibleForTesting
    static final String PASSWORD_VIEW = "bitbucket.internal.users.account.password";
    private static final String USER_SETTINGS_FRAGMENT_KEY = "bitbucket.page.user.settings";
    private final AuthenticationContext authenticationContext;
    private final CrowdControl crowdControl;
    private final UserAdminService userAdminService;
    private final UserService userService;
    private final I18nService i18nService;
    private final PluginFormFragmentsFactory formFragmentsFactory;
    private final SpringValidatorAdapter validatorAdapter;
    private final NavBuilder navBuilder;
    private final AuthenticationHelper authenticationHelper;

    @Autowired
    public UserAccountController(CrowdControl crowdControl, I18nService i18nService, PluginFormFragmentsFactory formFragmentsFactory, SpringValidatorAdapter validatorAdapter, AuthenticationContext authenticationContext, UserAdminService userAdminService, UserService userService, NavBuilder navBuilder, AuthenticationHelper authenticationHelper) {
        this.authenticationContext = authenticationContext;
        this.crowdControl = crowdControl;
        this.formFragmentsFactory = formFragmentsFactory;
        this.i18nService = i18nService;
        this.userAdminService = userAdminService;
        this.userService = userService;
        this.validatorAdapter = validatorAdapter;
        this.navBuilder = navBuilder;
        this.authenticationHelper = authenticationHelper;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView viewSettings() {
        ApplicationUser user = this.getCurrentUserOrThrow();
        DetailedUser detailedUser = this.userAdminService.getUserDetails(user);
        AccountSettingsForm form = new AccountSettingsForm();
        return this.showSettingsPage(SETTINGS_VIEW, detailedUser, false, this.populateFormWithUserDetails(form, detailedUser));
    }

    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView updateSettings(AccountSettingsForm form, Errors errors, HttpServletRequest request) {
        ApplicationUser user = this.getCurrentUserOrThrow();
        DetailedUser detailedUser = this.userAdminService.getUserDetails(user);
        if (detailedUser.isMutableDetails()) {
            this.validatorAdapter.validate((Object)form, errors);
        } else {
            form = this.populateFormWithUserDetails(form, detailedUser);
        }
        PluginFormFragments pluginFormFragments = this.getFormFragment(detailedUser);
        PluginValidationErrors pluginErrors = new PluginValidationErrors(errors);
        pluginFormFragments.validate(request.getParameterMap(), (ValidationErrors)pluginErrors);
        if (errors.hasErrors() || pluginErrors.hasFieldErrors()) {
            return this.showSettingsPage(SETTINGS_VIEW, detailedUser, false, form, errors, pluginFormFragments.getErrorHtml(request.getParameterMap(), pluginErrors.getFieldErrors()));
        }
        if (detailedUser.isMutableDetails()) {
            user = this.userService.updateUser(form.getDisplayName(), form.getEmailAddress());
        }
        pluginFormFragments.execute(request.getParameterMap());
        detailedUser = this.userAdminService.getUserDetails(user);
        return this.showSettingsPage(SETTINGS_VIEW, detailedUser, true, form);
    }

    private PluginFormFragments getFormFragment(DetailedUser detailedUser) {
        return this.formFragmentsFactory.forKey(USER_SETTINGS_FRAGMENT_KEY, (Map)ImmutableMap.of((Object)"user", (Object)detailedUser));
    }

    private AccountSettingsForm populateFormWithUserDetails(AccountSettingsForm form, DetailedUser detailedUser) {
        form.setDisplayName(detailedUser.getDisplayName());
        form.setEmailAddress(detailedUser.getEmailAddress());
        return form;
    }

    private ModelAndView showSettingsPage(String viewName, DetailedUser detailedUser, boolean saved, AccountSettingsForm form) {
        return this.showSettingsPage(viewName, detailedUser, saved, form, null, null);
    }

    private ModelAndView showSettingsPage(String viewName, DetailedUser detailedUser, boolean saved, AccountSettingsForm form, Errors errors, String pluginFieldErrors) {
        StashSoyResponseBuilder builder = (StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(viewName).put("user", (Object)detailedUser)).put("accountSettingsForm", (Object)form)).put("mutableDetails", (Object)detailedUser.isMutableDetails())).put("pluginFieldsContent", (Object)(pluginFieldErrors != null ? pluginFieldErrors : this.getFormFragment(detailedUser).getViewHtml()))).put("saved", (Object)saved);
        if (errors != null) {
            builder.putValidationErrors(errors);
        }
        return builder.build();
    }

    @RequestMapping(value={"/password"}, method={RequestMethod.GET})
    public ModelAndView viewPassword() {
        ApplicationUser user = this.getCurrentUserOrThrow();
        return this.showPasswordPage(this.userAdminService.getUserDetails(user), false, null);
    }

    @RequestMapping(value={"/password"}, method={RequestMethod.POST})
    public ModelAndView updatePassword(@Valid AccountPasswordForm form, Errors errors, HttpServletRequest request) {
        ApplicationUser user = this.getCurrentUserOrThrow();
        DetailedUser detailedUser = this.userAdminService.getUserDetails(user);
        if (errors.hasErrors()) {
            return this.showPasswordPage(detailedUser, false, errors);
        }
        try {
            this.userService.authenticateWithCaptcha(detailedUser.getName(), form.getCurrentPassword());
            this.userService.updatePassword(form.getCurrentPassword(), form.getNewPassword());
        }
        catch (IncorrectPasswordAuthenticationException e) {
            errors.rejectValue("currentPassword", "com.atlassian.stash.validation.password.incorrect.message", this.i18nService.getMessage("bitbucket.web.user.invalidpassword", new Object[0]));
            return this.showPasswordPage(detailedUser, false, errors);
        }
        catch (CaptchaRequiredAuthenticationException e) {
            this.authenticationHelper.setAuthenticationException(request, (AuthenticationException)new LockedException(this.i18nService.createKeyedMessage("bitbucket.service.user.toomanyfailedauthattempts", new Object[0]).getLocalisedMessage()));
            this.authenticationHelper.setCachedUsername(request, detailedUser.getName());
            this.userService.unauthenticate();
            return this.showLoginPage(this.navBuilder.account().password().buildAbsolute());
        }
        return this.showPasswordPage(detailedUser, true, errors);
    }

    private ApplicationUser getCurrentUserOrThrow() {
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser == null) {
            throw new AccessDeniedException(this.i18nService.getMessage("bitbucket.web.account.anonymous.error", new Object[0]));
        }
        return currentUser;
    }

    private ModelAndView showPasswordPage(DetailedUser detailedUser, boolean saved, Errors errors) {
        StashSoyResponseBuilder builder = (StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(PASSWORD_VIEW).put("user", (Object)detailedUser)).put("editablePassword", (Object)this.crowdControl.canResetPassword(detailedUser.getName()))).put("saved", (Object)saved);
        if (errors != null) {
            builder.putValidationErrors(errors);
        }
        return builder.build();
    }

    private ModelAndView showLoginPage(String nextUrl) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"next", (Object)nextUrl);
        return new ModelAndView((View)new RedirectView(this.navBuilder.login().buildConfigured(), true), (Map)builder.build());
    }
}

