/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.users;

import com.atlassian.bitbucket.IntegrityException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.license.LicenseLimitException;
import com.atlassian.bitbucket.license.LicenseService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.crowd.exception.runtime.CrowdRuntimeException;
import com.atlassian.extras.api.bitbucket.BitbucketServerLicense;
import com.atlassian.soy.springmvc.errors.ErrorUtils;
import com.atlassian.stash.internal.auth.AuthenticationHelper;
import com.atlassian.stash.internal.auth.CaptchaResponse;
import com.atlassian.stash.internal.user.CaptchaService;
import com.atlassian.stash.internal.web.auth.IgnoresXsrf;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import com.atlassian.stash.internal.web.users.SignUpController;
import com.atlassian.stash.internal.web.util.ControllerSupport;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/signup"})
public class SignUpController
extends ControllerSupport {
    private static final String FORM = "bitbucket.internal.users.signup";
    private final CaptchaService captchaService;
    private final LicenseService licenseService;
    private final ApplicationPropertiesService propertiesService;
    private final SecurityService securityService;
    private final UserAdminService userAdminService;
    private final AuthenticationHelper authenticationHelper;

    @Autowired
    public SignUpController(I18nService i18nService, CaptchaService captchaService, LicenseService licenseService, ApplicationPropertiesService propertiesService, SecurityService securityService, UserAdminService userAdminService, AuthenticationHelper authenticationHelper) {
        super(i18nService);
        this.authenticationHelper = authenticationHelper;
        this.captchaService = captchaService;
        this.licenseService = licenseService;
        this.propertiesService = propertiesService;
        this.securityService = securityService;
        this.userAdminService = userAdminService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView showSignUpForm() {
        if (this.isPublicSignupNotAllowed()) {
            return this.redirectToLogin();
        }
        return this.signUpForm(new SignUpForm()).build();
    }

    @RequestMapping(method={RequestMethod.POST})
    @IgnoresXsrf
    public ModelAndView signUpUser(HttpServletRequest request, @Valid SignUpForm form, Errors errors, RedirectAttributes redirectAttributes) {
        if (this.isPublicSignupNotAllowed()) {
            return this.redirectToLogin();
        }
        if (this.propertiesService.isShowCaptchaOnSignUp() && (StringUtils.isEmpty((CharSequence)form.getCaptcha()) || !this.captchaService.validateCaptchaResponse(new CaptchaResponse(request.getSession().getId(), form.getCaptcha())))) {
            KeyedMessage keyedMsg = this.i18nService.createKeyedMessage("bitbucket.web.signup.captcha.incorrect", new Object[0]);
            errors.rejectValue("captcha", keyedMsg.getKey(), keyedMsg.getLocalisedMessage());
        }
        if (errors.hasErrors()) {
            return this.signUpForm(form).putValidationErrors(errors).build();
        }
        try {
            this.createUser(form);
        }
        catch (IntegrityException e) {
            return ((StashSoyResponseBuilder)this.signUpForm(form).putFormErrors(new String[]{e.getLocalizedMessage()})).build();
        }
        catch (CrowdRuntimeException e) {
            return ((StashSoyResponseBuilder)this.signUpForm(form).putFormErrors(new String[]{ErrorUtils.getLocalizedMessageOfRootCause((Throwable)e)})).build();
        }
        catch (LicenseLimitException e) {
            return this.signUpForm(form, true).build();
        }
        request.getSession(true);
        this.authenticationHelper.setCachedUsername(request, form.getUsername());
        redirectAttributes.addFlashAttribute("wasSuccessfulSignedUp", (Object)true);
        return this.redirectToLogin();
    }

    private void createUser(SignUpForm form) throws IntegrityException, LicenseLimitException, CrowdRuntimeException {
        this.securityService.withPermission(Permission.ADMIN, "Create user through signup").call((Operation)new /* Unavailable Anonymous Inner Class!! */);
    }

    private StashSoyResponseBuilder signUpForm(SignUpForm form) {
        boolean unlimited;
        int userCount = this.licenseService.getLicensedUsersCount();
        BitbucketServerLicense license = this.licenseService.get();
        int userLimit = -1;
        boolean bl = unlimited = license == null || license.isUnlimitedNumberOfUsers();
        if (!unlimited) {
            userLimit = license.getMaximumNumberOfUsers();
        }
        return this.signUpForm(form, !unlimited && userCount >= userLimit);
    }

    private StashSoyResponseBuilder signUpForm(SignUpForm form, boolean userLimitReached) {
        return (StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(FORM).put("form", (Object)form)).put("showCaptcha", (Object)this.propertiesService.isShowCaptchaOnSignUp())).put("userLimitReached", (Object)userLimitReached)).put("instanceName", (Object)this.propertiesService.getDisplayName());
    }

    private boolean isPublicSignupNotAllowed() {
        return !this.propertiesService.isAllowPublicSignUp();
    }

    private ModelAndView redirectToLogin() {
        return new ModelAndView("redirect:/login?signedUp");
    }

    static /* synthetic */ UserAdminService access$000(SignUpController x0) {
        return x0.userAdminService;
    }
}

