/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.startup;

import com.atlassian.johnson.spring.lifecycle.LifecycleState;
import com.atlassian.johnson.spring.lifecycle.LifecycleUtils;
import com.atlassian.stash.internal.johnson.JohnsonUtils;
import com.atlassian.stash.internal.lifecycle.StartupManager;
import com.atlassian.stash.internal.rest.RestProgress;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.MappingJsonFactory;

public class StartupServlet
extends HttpServlet {
    private static final JsonFactory JSON = new MappingJsonFactory();
    private final StartupManager startupManager;

    public StartupServlet(StartupManager startupManager) {
        this.startupManager = startupManager;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if ("application/json".equals(request.getHeader("Accept"))) {
            response.setStatus(200);
            response.setHeader("Content-Type", "application/json;charset=UTF-8");
            try (JsonGenerator jsonGenerator = JSON.createJsonGenerator((OutputStream)response.getOutputStream(), JsonEncoding.UTF8);){
                jsonGenerator.writeObject((Object)ImmutableMap.of((Object)"progress", (Object)new RestProgress(this.startupManager.getProgress()), (Object)"state", (Object)this.getCurrentState()));
            }
        } else if (this.startupManager.isStarting()) {
            request.setAttribute("startupManager", (Object)this.startupManager);
            request.getRequestDispatcher("/startup.jsp").forward((ServletRequest)request, (ServletResponse)response);
        } else {
            response.sendRedirect(JohnsonUtils.getRedirectUrl((HttpServletRequest)request, (String)request.getContextPath()));
        }
    }

    @VisibleForTesting
    protected LifecycleState getCurrentState() {
        return LifecycleUtils.getCurrentState((ServletContext)this.getServletContext());
    }
}

