/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.soy.functions.nav;

import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.soy.renderer.JsExpression;
import com.atlassian.stash.internal.web.soy.functions.nav.BaseRepoNavFunction;
import com.atlassian.stash.internal.web.soy.functions.nav.JsNavBuilder;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public class CompareNavFunction
extends BaseRepoNavFunction {
    public CompareNavFunction(NavBuilder navBuilder) {
        super(navBuilder, "nav_compare_refs", (Set)ImmutableSet.of((Object)2, (Object)4));
    }

    protected JsNavBuilder initJsBuilder(JsExpression ... jsExpressions) {
        JsNavBuilder compare = this.repo(jsExpressions).compare();
        if (jsExpressions.length == 2) {
            return compare;
        }
        if (jsExpressions.length == 4) {
            JsExpression sourceBranch = jsExpressions[2];
            JsExpression targetBranch = jsExpressions[3];
            return compare.callMethod("sourceBranch", new JsExpression[]{sourceBranch}).callMethod("targetBranch", new JsExpression[]{targetBranch});
        }
        throw this.newIllegalArgumentException((Object[])jsExpressions);
    }

    protected NavBuilder.Builder initBuilder(Object ... args) {
        NavBuilder.Compare compare = this.repo(args).compare();
        if (args.length == 2) {
            return compare;
        }
        if (args.length == 4) {
            String sourceBranch = this.toRefId(args[2]);
            String targetBranch = this.toRefId(args[3]);
            return compare.sourceBranch(sourceBranch).targetBranch(targetBranch);
        }
        throw this.newIllegalArgumentException(args);
    }

    private IllegalArgumentException newIllegalArgumentException(Object[] args) {
        return new IllegalArgumentException("Unsupported arguments: " + Joiner.on((char)',').join(args));
    }

    private String toRefId(Object o) {
        if (o instanceof Ref) {
            return ((Ref)o).getId();
        }
        if (o instanceof String) {
            return (String)o;
        }
        throw new IllegalArgumentException("Is not a ref: " + o);
    }
}

