/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.soy.functions;

import com.atlassian.soy.renderer.JsExpression;
import com.atlassian.soy.renderer.SoyClientFunction;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.atlassian.stash.internal.web.fragments.WebFragmentSupport;
import com.atlassian.stash.internal.web.fragments.WebItemData;
import com.atlassian.stash.internal.web.soy.functions.SoyArgumentUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WebItemFunction
implements SoyServerFunction<List<WebItemData>>,
SoyClientFunction {
    private static final Set<Integer> VALID_ARG_SIZES = SoyArgumentUtils.argCountFromTo((int)1, (int)2);
    private final WebFragmentSupport webFragmentSupport;

    public WebItemFunction(WebFragmentSupport webFragmentSupport) {
        this.webFragmentSupport = webFragmentSupport;
    }

    public String getName() {
        return "getWebItems";
    }

    public JsExpression generate(JsExpression ... args) {
        Preconditions.checkArgument((boolean)VALID_ARG_SIZES.contains(args.length), (String)"invalid number of arguments: %s", (Object[])new Object[]{args.length});
        return new JsExpression("WebFragments.getWebItems(" + args[0].getText() + (args.length > 1 ? "," + args[1].getText() : "") + ")");
    }

    public List<WebItemData> apply(Object ... args) {
        Preconditions.checkArgument((boolean)VALID_ARG_SIZES.contains(args.length), (String)"invalid number of arguments: %s", (Object[])new Object[]{args.length});
        String location = (String)Preconditions.checkNotNull((Object)args[0]);
        HashMap context = args.length == 2 && args[1] != null ? (Map)args[1] : Maps.newHashMap();
        return this.webFragmentSupport.getWebItems(location, (Map)context, false);
    }

    public Set<Integer> validArgSizes() {
        return VALID_ARG_SIZES;
    }
}

