/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.soy.functions;

import com.atlassian.bitbucket.json.JsonRenderer;
import com.atlassian.soy.renderer.JsExpression;
import com.atlassian.soy.renderer.SoyClientFunction;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class ToJsonFunction
implements SoyServerFunction<String>,
SoyClientFunction {
    private static final Set<Integer> VALID_ARG_SIZES = ImmutableSet.of((Object)1, (Object)2);
    private static final CharMatcher SEPARATORS = CharMatcher.anyOf((CharSequence)"\u2028\u2029");
    private final JsonRenderer jsonRenderer;

    public ToJsonFunction(JsonRenderer jsonRenderer) {
        this.jsonRenderer = jsonRenderer;
    }

    public JsExpression generate(JsExpression ... args) {
        return new JsExpression("JSON.stringify(" + args[0].getText() + ").replace(/\\//g, '\\\\/')");
    }

    public String getName() {
        return "to_json";
    }

    public String apply(Object ... objects) {
        return this.safeJson(this.jsonRenderer.render(objects[0], objects.length == 2 ? (Map)objects[1] : Collections.emptyMap()));
    }

    private String safeJson(String json) {
        return SEPARATORS.replaceFrom((CharSequence)json, (CharSequence)"\\n");
    }

    public Set<Integer> validArgSizes() {
        return VALID_ARG_SIZES;
    }
}

