/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.soy.functions;

import com.atlassian.soy.renderer.JsExpression;
import com.atlassian.soy.renderer.SoyClientFunction;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.atlassian.stash.internal.web.soy.functions.SoyArgumentUtils;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class AbbreviatedCommitMessageFunction
implements SoyServerFunction<String>,
SoyClientFunction {
    public String getName() {
        return "commitMessage";
    }

    public String apply(Object ... args) {
        this.validate(args);
        String message = (String)args[0];
        int max = ((Number)args[1]).intValue();
        if (message.length() <= max) {
            return message;
        }
        int endOfFirstLine = message.indexOf(10);
        if (endOfFirstLine > 0 && endOfFirstLine <= max) {
            return message.substring(0, endOfFirstLine + 3 > max ? max - 3 : endOfFirstLine) + "...";
        }
        return StringUtils.abbreviate((String)message, (int)max);
    }

    private void validate(Object[] args) {
        SoyArgumentUtils.ensureArgumentTypeIsOneOf((Object[])args, (int)0, (Class[])new Class[]{String.class});
        SoyArgumentUtils.ensureArgumentTypeIsOneOf((Object[])args, (int)1, (Class[])new Class[]{Number.class});
    }

    public Set<Integer> validArgSizes() {
        return ImmutableSet.of((Object)2);
    }

    public JsExpression generate(JsExpression ... args) {
        return new JsExpression("require('bitbucket/internal/util/abbreviate-commit-message')(" + args[0].getText() + ", " + args[1].getText() + ")");
    }
}

