/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.setup;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.ServerException;
import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.jira.ApplicationTypeNotInstalledException;
import com.atlassian.bitbucket.jira.IncorrectApplicationBaseUrlException;
import com.atlassian.bitbucket.jira.JiraSetupException;
import com.atlassian.bitbucket.jira.JiraSetupService;
import com.atlassian.bitbucket.jira.JiraUserCredentialsException;
import com.atlassian.bitbucket.jira.NotAJiraServerException;
import com.atlassian.bitbucket.license.LicenseException;
import com.atlassian.bitbucket.license.LicenseService;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionAdminService;
import com.atlassian.bitbucket.permission.SetPermissionRequest;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.ui.PluginFormFragments;
import com.atlassian.bitbucket.ui.PluginFormFragmentsFactory;
import com.atlassian.bitbucket.ui.ValidationErrors;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.DevModeUtils;
import com.atlassian.bitbucket.util.UrlUtils;
import com.atlassian.bitbucket.validation.HttpURLValidator;
import com.atlassian.crowd.exception.CrowdException;
import com.atlassian.soy.springmvc.errors.ErrorUtils;
import com.atlassian.soy.springmvc.errors.WebErrorUtils;
import com.atlassian.stash.internal.ApplicationConstants;
import com.atlassian.stash.internal.db.DbType;
import com.atlassian.stash.internal.db.DbTypeBean;
import com.atlassian.stash.internal.i18n.LocaleHolder;
import com.atlassian.stash.internal.jdbc.DataSourceConfiguration;
import com.atlassian.stash.internal.jdbc.SimpleDataSourceConfiguration;
import com.atlassian.stash.internal.language.InternalLanguageService;
import com.atlassian.stash.internal.maintenance.MaintenanceCompletionCallback;
import com.atlassian.stash.internal.maintenance.MaintenanceTaskMonitor;
import com.atlassian.stash.internal.migration.DatabaseMigrationException;
import com.atlassian.stash.internal.migration.DatabaseMigrationService;
import com.atlassian.stash.internal.plugin.PluginValidationErrors;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.internal.user.InternalPermissionService;
import com.atlassian.stash.internal.web.admin.DbConfigForm;
import com.atlassian.stash.internal.web.auth.IgnoresXsrf;
import com.atlassian.stash.internal.web.locale.UserLocaleWebUtils;
import com.atlassian.stash.internal.web.setup.AdminUserForm;
import com.atlassian.stash.internal.web.setup.JiraIntegrationForm;
import com.atlassian.stash.internal.web.setup.MirrorForm;
import com.atlassian.stash.internal.web.setup.SettingsForm;
import com.atlassian.stash.internal.web.setup.SetupController;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import com.atlassian.stash.internal.web.util.ControllerSupport;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Conventions;
import org.springframework.stereotype.Controller;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@RequestMapping(value={"/setup"})
public class SetupController
extends ControllerSupport {
    static final String HAS_SETUP_DB_NAME = Conventions.getQualifiedAttributeName(SetupController.class, (String)"hasSetupDatabase");
    static final String DATABASE_VIEW = "bitbucket.internal.page.setup.database";
    static final String LICENSE_AND_SETTINGS_VIEW = "bitbucket.internal.page.setup.settings";
    static final String ADMIN_USER_VIEW = "bitbucket.internal.page.setup.adminUser";
    static final String JIRA_INTEGRATION_VIEW = "bitbucket.internal.page.setup.jiraIntegration";
    static final String MIRROR_VIEW = "bitbucket.internal.page.setup.mirror";
    static final String JIRA_UPM_INSTALL_URL_SUFFIX = "/plugins/servlet/upm#upgrade";
    static final String FIELD_BASE_URL = "baseUrl";
    private final EscalatedSecurityContext asSysAdmin;
    private final JiraSetupService jiraSetupService;
    private final InternalLanguageService languageService;
    private final LicenseService licenseService;
    private final LocaleHolder localeHolder;
    private final DatabaseMigrationService databaseMigrationService;
    private final NavBuilder navBuilder;
    private final PermissionAdminService permissionAdminService;
    private final InternalPermissionService permissionService;
    private final InternalApplicationPropertiesService propertiesService;
    private final UserAdminService userAdminService;
    private final UserService userService;
    private final PluginFormFragmentsFactory formFragmentsFactory;

    @Autowired
    public SetupController(I18nService i18nService, JiraSetupService jiraSetupService, InternalLanguageService languageService, LicenseService licenseService, LocaleHolder localeHolder, DatabaseMigrationService databaseMigrationService, NavBuilder navBuilder, PermissionAdminService permissionAdminService, InternalPermissionService permissionService, InternalApplicationPropertiesService propertiesService, SecurityService securityService, UserAdminService userAdminService, UserService userService, PluginFormFragmentsFactory formFragmentsFactory) {
        super(i18nService);
        this.jiraSetupService = jiraSetupService;
        this.languageService = languageService;
        this.licenseService = licenseService;
        this.localeHolder = localeHolder;
        this.databaseMigrationService = databaseMigrationService;
        this.navBuilder = navBuilder;
        this.permissionAdminService = permissionAdminService;
        this.permissionService = permissionService;
        this.propertiesService = propertiesService;
        this.userAdminService = userAdminService;
        this.userService = userService;
        this.formFragmentsFactory = formFragmentsFactory;
        this.asSysAdmin = securityService.withPermission(Permission.SYS_ADMIN, "SetupController");
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView setup(HttpSession session) {
        if (this.propertiesService.isSetup()) {
            return this.redirectToRoot();
        }
        ApplicationMode mode = this.propertiesService.getMode();
        switch (2.$SwitchMap$com$atlassian$bitbucket$server$ApplicationMode[mode.ordinal()]) {
            case 1: {
                return this.setupDefault(session);
            }
            case 2: {
                return this.setupMirrorView();
            }
        }
        this.log.error("Unexpected application mode '{}' reported.", (Object)mode);
        throw new IllegalStateException(String.format("Unexpected application mode '%s' reported.", mode));
    }

    private ModelAndView setupDefault(HttpSession session) {
        if (!this.hasSetupDatabase(session)) {
            return this.getDatabaseForm(DbTypeBean.DEFAULT, null, true).build();
        }
        if (!this.hasLicenseAndBaseUrl()) {
            return this.getSettingsForm(new SettingsForm()).build();
        }
        return this.hasAdminUser() ? this.getJiraForm().build() : this.getAdminUserForm().build();
    }

    private ModelAndView setupMirrorView() {
        MirrorForm form = new MirrorForm();
        form.setApplicationTitle(this.propertiesService.getDisplayName());
        URI baseUrl = this.propertiesService.getBaseUrl();
        if (baseUrl == null) {
            form.setBaseUrl(this.navBuilder.buildAbsolute());
        } else {
            form.setBaseUrl(baseUrl);
        }
        return this.createMirrorView(form, null, this.getMirrorPluginFragments().getViewHtml());
    }

    private ModelAndView createMirrorView(MirrorForm form, Errors errors, String pluginHtml) {
        boolean sslError = SetupController.isSslError((String)form.getBaseUrl());
        ArrayListMultimap fieldErrors = ArrayListMultimap.create();
        Object formErrors = ImmutableList.of();
        if (errors != null) {
            WebErrorUtils.toFieldErrorMap((Iterable)errors.getFieldErrors()).forEach((arg_0, arg_1) -> ((ListMultimap)fieldErrors).putAll(arg_0, arg_1));
            formErrors = WebErrorUtils.toFormErrors((List)errors.getGlobalErrors());
        }
        if (sslError && !fieldErrors.containsKey((Object)"baseUrl")) {
            fieldErrors.put((Object)"baseUrl", (Object)this.i18nService.getMessage("bitbucket.web.setup.mirror.baseUrl.https.error", new Object[0]));
        }
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)this.setupSoyResponseBuilder("bitbucket.internal.page.setup.mirror").put("form", (Object)form)).put("pluginHtml", (Object)pluginHtml)).put("sslError", (Object)sslError)).put("fieldErrors", (Object)fieldErrors.asMap())).put("formErrors", formErrors)).build();
    }

    private PluginFormFragments getMirrorPluginFragments() {
        return this.formFragmentsFactory.forKey("bitbucket.mirror.setup", (Map)ImmutableMap.of());
    }

    private StashSoyResponseBuilder getAdminUserForm() {
        return this.setupSoyResponseBuilder("bitbucket.internal.page.setup.adminUser");
    }

    private StashSoyResponseBuilder getDatabaseForm(DbTypeBean currentDbType, DbConfigForm form, boolean isInternal) {
        return (StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)this.setupSoyResponseBuilder("bitbucket.internal.page.setup.database").put("currentDbType", (Object)currentDbType)).put("dbTypes", (Object)DbTypeBean.ALL)).put("dcName", (Object)Product.DATA_CENTER_NAME)).put("form", (Object)form)).put("isInternal", (Object)isInternal)).put("languages", (Object)UserLocaleWebUtils.toSoy((Iterable)this.languageService.getLanguages(), (Iterable)this.localeHolder.getLocales(new Locale[0])));
    }

    private StashSoyResponseBuilder getSettingsForm(SettingsForm form) {
        String license = this.licenseService.getAsString();
        if (StringUtils.isNotBlank((CharSequence)license)) {
            form.setLicense(license);
        }
        form.setBaseUrl(this.propertiesService.getBaseUrl());
        form.setApplicationTitle(this.propertiesService.getDisplayName());
        return (StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)this.setupSoyResponseBuilder("bitbucket.internal.page.setup.settings").put("createAccountAndGenerateEvalUrl", (Object)this.getCreateAccountAndGenerateEvalUrl())).put("form", (Object)form)).put("generateEvalUrl", (Object)this.getGenerateEvalUrl())).put("serverId", (Object)this.propertiesService.getServerId());
    }

    private StashSoyResponseBuilder getJiraForm() {
        URI baseUrl = this.propertiesService.getBaseUrl();
        return (StashSoyResponseBuilder)this.setupSoyResponseBuilder("bitbucket.internal.page.setup.jiraIntegration").put("form", (Object)new JiraIntegrationForm(baseUrl == null ? null : baseUrl.toASCIIString()));
    }

    @RequestMapping(params={"step=database"}, method={RequestMethod.POST})
    public ModelAndView configureDatabase(HttpServletRequest request, HttpSession session, @RequestParam(value="internal", defaultValue="true") boolean isInternal, @RequestParam(value="locale", required=false) String locale, @Valid DbConfigForm form, Errors errors) {
        this.checkInDefaultModeAndSetupNotComplete();
        this.setLocale(locale);
        if (this.hasSetupDatabase(session)) {
            return this.showNextStep();
        }
        DbTypeBean currentDbType = DbTypeBean.forKey((String)form.getType());
        if (currentDbType == null) {
            errors.rejectValue("type", "bitbucket.web.setup.database.type.required", "You must select database type");
        }
        if (!isInternal && errors.hasErrors()) {
            return this.getDatabaseForm(currentDbType, form, false).putValidationErrors(errors).build();
        }
        if (isInternal) {
            this.markDatabaseAsSetup(session);
        } else {
            String jdbcUrl = currentDbType.generateUrl(form.getHostname(), form.getDatabase(), form.getPortAsInteger());
            SimpleDataSourceConfiguration configuration = new SimpleDataSourceConfiguration(currentDbType.getDriverClassName(), jdbcUrl, form.getUsername(), form.getPassword());
            try {
                if (request.getParameter("test") != null) {
                    this.performTestDatabaseConnection((DataSourceConfiguration)configuration);
                    return ((StashSoyResponseBuilder)this.getDatabaseForm(currentDbType, form, false).put("testPassed", (Object)true)).build();
                }
                this.performDatabaseSetup(session, (DataSourceConfiguration)configuration);
            }
            catch (DatabaseMigrationException e) {
                return ((StashSoyResponseBuilder)this.getDatabaseForm(currentDbType, form, false).put("migrationException", (Object)e)).build();
            }
            catch (ServiceException e) {
                return this.getDatabaseForm(currentDbType, form, false).putFormErrors(e).build();
            }
        }
        return this.showNextStep();
    }

    private void performTestDatabaseConnection(DataSourceConfiguration configuration) {
        this.asSysAdmin.call(() -> {
            this.databaseMigrationService.validateConfiguration(configuration);
            return null;
        });
    }

    private void performDatabaseSetup(HttpSession session, DataSourceConfiguration configuration) {
        MaintenanceTaskMonitor task = (MaintenanceTaskMonitor)this.asSysAdmin.call(() -> this.databaseMigrationService.setup(configuration));
        task.registerCallback((MaintenanceCompletionCallback)new /* Unavailable Anonymous Inner Class!! */);
        try {
            task.awaitCompletion();
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error("An unexpected exception occurred while setting up the database", (Throwable)e);
        }
    }

    @IgnoresXsrf
    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView callbackForMac(@Valid SettingsForm form, Errors errors) {
        this.checkInDefaultModeAndSetupNotComplete();
        return this.getSettingsForm(form).build();
    }

    @RequestMapping(params={"step=settings"}, method={RequestMethod.POST})
    public ModelAndView enterSettings(@Valid SettingsForm form, Errors errors) {
        this.checkInDefaultModeAndSetupNotComplete();
        if (errors.hasErrors()) {
            return this.getSettingsForm(form).putValidationErrors(errors).build();
        }
        try {
            this.setNameAndBaseUrl(form.getApplicationTitle(), form.getBaseUrl());
            this.setLicense(form.getLicense());
        }
        catch (LicenseException e) {
            Map<String, List<String>> fieldErrors = Collections.singletonMap("license", Collections.singletonList(e.getLocalizedMessage()));
            return ((StashSoyResponseBuilder)this.getSettingsForm(form).putFieldErrors(fieldErrors)).build();
        }
        catch (ServiceException e) {
            return ((StashSoyResponseBuilder)this.getSettingsForm(form).putFormErrors(new String[]{e.getLocalizedMessage()})).build();
        }
        return this.showNextStep();
    }

    @RequestMapping(params={"step=user"}, method={RequestMethod.POST})
    public ModelAndView addFirstAdminUser(@Valid AdminUserForm form, Errors errors) {
        this.checkInDefaultModeAndSetupNotComplete();
        if (errors.hasErrors()) {
            return this.showForm("bitbucket.internal.page.setup.adminUser", (Object)form, errors, new String[0]);
        }
        try {
            this.createAdminUser(form);
        }
        catch (Exception e) {
            return this.showForm("bitbucket.internal.page.setup.adminUser", (Object)form, null, new String[]{ErrorUtils.getLocalizedMessageOfRootCause((Throwable)e)});
        }
        if (!form.isIntegrateWithJira()) {
            this.markSetupAsComplete();
        }
        return this.showNextStep();
    }

    @RequestMapping(params={"step=jira"}, method={RequestMethod.POST})
    public ModelAndView setupJiraIntegration(@Valid JiraIntegrationForm form, Errors errors) {
        this.checkInDefaultModeAndSetupNotComplete();
        if (!form.isSkip()) {
            if (errors.hasErrors()) {
                return this.showForm("bitbucket.internal.page.setup.jiraIntegration", (Object)form, errors, new String[0]);
            }
            try {
                this.integrateWithJira(form);
            }
            catch (NotAJiraServerException e) {
                errors.rejectValue("jiraBaseUrl", "bitbucket.web.setup.stash.bad.jira.url", e.getLocalizedMessage());
                return this.showForm("bitbucket.internal.page.setup.jiraIntegration", (Object)form, errors, new String[0]);
            }
            catch (JiraUserCredentialsException e) {
                return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)this.setupSoyResponseBuilder("bitbucket.internal.page.setup.jiraIntegration").put("form", (Object)form)).put("credentialsProblem", (Object)true)).build();
            }
            catch (IncorrectApplicationBaseUrlException e) {
                errors.rejectValue("stashBaseUrl", "bitbucket.web.setup.stash.bad.stash.url", e.getLocalizedMessage());
                return this.showForm("bitbucket.internal.page.setup.jiraIntegration", (Object)form, errors, new String[0]);
            }
            catch (ApplicationTypeNotInstalledException e) {
                return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)this.setupSoyResponseBuilder("bitbucket.internal.page.setup.jiraIntegration").put("form", (Object)form)).put("stashUalTypesMissing", (Object)true)).put("jiraUpmUrl", (Object)UrlUtils.concatenate((String)form.getJiraBaseUrl(), (String[])new String[]{"/plugins/servlet/upm#upgrade"}))).build();
            }
            catch (JiraSetupException e) {
                return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)this.setupSoyResponseBuilder("bitbucket.internal.page.setup.jiraIntegration").put("form", (Object)form)).put("jiraIntegrationError", (Object)e.getLocalizedMessage())).build();
            }
        }
        this.markSetupAsComplete();
        return this.redirectToRoot();
    }

    @RequestMapping(params={"step=mirror"}, method={RequestMethod.POST})
    public ModelAndView setupMirror(@Valid MirrorForm form, Errors errors, HttpServletRequest request) {
        this.checkInMirrorModeAndSetupNotComplete();
        PluginFormFragments mirrorPluginFragments = this.getMirrorPluginFragments();
        PluginValidationErrors pluginErrors = new PluginValidationErrors(errors);
        Map parameterMap = request.getParameterMap();
        mirrorPluginFragments.validate(parameterMap, (ValidationErrors)pluginErrors);
        if (pluginErrors.hasErrors() || SetupController.isSslError((String)form.getBaseUrl())) {
            return this.createMirrorView(form, errors, mirrorPluginFragments.getErrorHtml(parameterMap, pluginErrors.getFieldErrors()));
        }
        this.setNameAndBaseUrl(form.getApplicationTitle(), form.getBaseUrl());
        mirrorPluginFragments.execute(parameterMap);
        this.markSetupAsComplete();
        return new ModelAndView("redirect:/mirror?setup=true");
    }

    private boolean hasSetupDatabase(HttpSession session) {
        return Boolean.TRUE.equals(session.getAttribute(HAS_SETUP_DB_NAME)) || !DbType.isInternal((String)this.propertiesService.getJdbcDriver());
    }

    private boolean hasLicenseAndBaseUrl() {
        return this.licenseService.isPresent() && this.propertiesService.getBaseUrl() != null;
    }

    private void setNameAndBaseUrl(String name, String baseURL) {
        this.asSysAdmin.call(() -> {
            this.propertiesService.setDisplayName(name);
            this.propertiesService.setBaseURL(UrlUtils.uncheckedCreateURI((String)baseURL));
            return null;
        });
    }

    private void setLicense(String license) {
        this.asSysAdmin.call(() -> {
            this.licenseService.set(license);
            return null;
        });
    }

    private void setLocale(String locale) {
        this.asSysAdmin.call(() -> {
            this.propertiesService.setLocale(LocaleUtils.toLocale((String)locale));
            return null;
        });
    }

    private boolean hasAdminUser() {
        return (Boolean)this.asSysAdmin.call(() -> !this.permissionService.getUsersWithPermission(Permission.SYS_ADMIN).isEmpty());
    }

    private void createAdminUser(AdminUserForm form) throws CrowdException {
        this.asSysAdmin.call(() -> {
            this.userAdminService.createUser(form.getUsername(), form.getPassword(), form.getFullname(), form.getEmail());
            ApplicationUser user = this.userService.getUserByName(form.getUsername());
            if (user == null) {
                throw new ServerException(this.i18nService.createKeyedMessage("bitbucket.web.setup.cannotcreateuser", new Object[]{form.getUsername(), ApplicationConstants.PRODUCT_NAME}));
            }
            this.permissionAdminService.setPermission(new SetPermissionRequest.Builder().globalPermission(Permission.SYS_ADMIN).user(user).build());
            return null;
        });
    }

    private void integrateWithJira(JiraIntegrationForm form) throws JiraSetupException {
        this.asSysAdmin.call(() -> {
            try {
                this.jiraSetupService.createLink(new URI(form.getJiraBaseUrl()), new URI(form.getStashBaseUrl()), form.getJiraAdminUsername(), form.getJiraAdminPassword(), form.getAddUserDirectory());
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException(HttpURLValidator.class.getName() + " should have successfully validated uri String, but failed to create new URI from String", e);
            }
            return null;
        });
    }

    private ModelAndView showForm(String formView, Object form, Errors errors, String ... globalErrors) {
        StashSoyResponseBuilder builder = (StashSoyResponseBuilder)((StashSoyResponseBuilder)this.setupSoyResponseBuilder(formView).put("form", form)).putFormErrors(globalErrors);
        if (errors != null) {
            builder.putValidationErrors(errors);
        }
        return builder.build();
    }

    private void markDatabaseAsSetup(HttpSession session) {
        session.setAttribute(HAS_SETUP_DB_NAME, (Object)Boolean.TRUE);
    }

    private void markSetupAsComplete() {
        this.asSysAdmin.call(() -> {
            this.propertiesService.setSetup(true);
            return null;
        });
    }

    private void checkSetupNotComplete() {
        if (this.propertiesService.isSetup()) {
            throw new IllegalStateException(ApplicationConstants.PRODUCT_NAME + " is already setup!");
        }
    }

    private void checkInMirrorModeAndSetupNotComplete() {
        this.checkSetupNotComplete();
        if (this.propertiesService.getMode() != ApplicationMode.MIRROR) {
            throw new IllegalStateException("Bitbucket not in mirror mode.");
        }
    }

    private void checkInDefaultModeAndSetupNotComplete() {
        this.checkSetupNotComplete();
        if (this.propertiesService.getMode() != ApplicationMode.DEFAULT) {
            throw new IllegalStateException("Bitbucket not in default mode.");
        }
    }

    private ModelAndView showNextStep() {
        return new ModelAndView("redirect:/setup");
    }

    private ModelAndView redirectToRoot() {
        return new ModelAndView("redirect:/");
    }

    private String getCreateAccountAndGenerateEvalUrl() {
        return (DevModeUtils.isEnabled() ? "https://id.stg.internal.atlassian.com/signup" : "https://id.atlassian.com/signup") + "?application=" + "mac" + "&tenant=" + "&continue=" + UrlUtils.encodeURL((String)this.getGenerateEvalUrl());
    }

    private String getGenerateEvalUrl() {
        String callback = this.navBuilder.setup().buildAbsolute();
        return (DevModeUtils.isEnabled() ? "https://my.stg.intsys.atlassian.com/license/evaluation" : "http://www.atlassian.com/ex/GenerateLicense.jspa") + "?utm_nooverride=1" + "&ref=prod" + "&product=" + "stash" + "&version=" + this.propertiesService.getBuildVersion() + "&build=" + this.propertiesService.getBuildNumber() + "&sid=" + this.propertiesService.getServerId() + "&licensefieldname=" + "license" + "&callback=" + callback;
    }

    private StashSoyResponseBuilder setupSoyResponseBuilder(@Nonnull String viewName) {
        StashSoyResponseBuilder responseBuilder = new StashSoyResponseBuilder(viewName);
        Map da = responseBuilder.getDataAttributes();
        da.put("server-id", this.propertiesService.getServerId());
        da.put("dev-mode-enabled", Boolean.toString(DevModeUtils.isEnabled()));
        return responseBuilder;
    }

    private static boolean isHttpsUrl(String url) {
        if (url == null) {
            return false;
        }
        try {
            return SetupController.isHttpsUrl((URL)new URL(url));
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    private static boolean isHttpsUrl(URL url) {
        return url != null && "https".equalsIgnoreCase(url.getProtocol());
    }

    private static boolean isSslError(String url) {
        return !DevModeUtils.isEnabled() && !SetupController.isHttpsUrl((String)url);
    }

    static /* synthetic */ Logger access$000(SetupController x0) {
        return x0.log;
    }

    static /* synthetic */ void access$100(SetupController x0, HttpSession x1) {
        x0.markDatabaseAsSetup(x1);
    }

    static /* synthetic */ Logger access$200(SetupController x0) {
        return x0.log;
    }
}

