/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.repos;

import com.atlassian.bitbucket.content.ContentTreeNode;
import com.atlassian.bitbucket.content.Submodule;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class ViewFile
implements Comparable<ViewFile> {
    private final String browseUrl;
    private final String collapsedParents;
    private final String contentId;
    private final String fullName;
    private final String name;
    private final String repositoryUrl;
    private final ContentTreeNode.Type type;
    private final String url;

    public ViewFile(ContentTreeNode node, String url) {
        this(Objects.requireNonNull(node, "node"), url, null, null);
    }

    public ViewFile(Submodule submodule) {
        this((ContentTreeNode)Objects.requireNonNull(submodule, "submodule"), submodule.getUrl(), submodule.getBrowseUrl(), submodule.getRepositoryUrl());
    }

    private ViewFile(ContentTreeNode node, String url, String browseUrl, String repositoryUrl) {
        this.browseUrl = browseUrl;
        this.repositoryUrl = repositoryUrl;
        this.url = Objects.requireNonNull(url, "url");
        String parentPath = StringUtils.defaultString((String)node.getPath().getParent());
        this.collapsedParents = parentPath.isEmpty() ? "" : StringUtils.appendIfMissing((String)parentPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        this.contentId = node.getContentId();
        this.name = node.getPath().getName();
        this.type = node.getType();
        this.fullName = this.collapsedParents.isEmpty() ? this.name : this.collapsedParents + this.name;
    }

    public String getCollapsedParents() {
        return this.collapsedParents;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public String getBrowseUrl() {
        return this.browseUrl;
    }

    public String getContentId() {
        return this.contentId;
    }

    public ContentTreeNode.Type getType() {
        return this.type;
    }

    public ContentTreeNode.Type getTypeValue() {
        return this.type;
    }

    @Override
    public int compareTo(@Nonnull ViewFile o) {
        if (this.getTypeValue() == ContentTreeNode.Type.DIRECTORY ^ o.getTypeValue() == ContentTreeNode.Type.DIRECTORY) {
            return this.getTypeValue() == ContentTreeNode.Type.DIRECTORY ? -1 : 1;
        }
        int i = this.getFullName().compareToIgnoreCase(o.getFullName());
        return i == 0 ? this.getFullName().compareTo(o.getFullName()) : i;
    }
}

