/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.repos;

import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.ui.PluginFormFragmentsFactory;
import com.atlassian.stash.internal.project.InternalProjectService;
import com.atlassian.stash.internal.scm.InternalScmService;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import com.atlassian.stash.internal.web.util.CompareControllerSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/projects/{projectKey}/repos/{repoSlug}/compare"})
public class CompareController
extends CompareControllerSupport {
    private static final String COMPARE_PAGE = "bitbucket.internal.page.compare";

    @Autowired
    public CompareController(I18nService i18nService, RefService refService, PermissionService permissionService, InternalProjectService projectService, RepositoryService repositoryService, InternalScmService scmService, CommitService commitService, PluginFormFragmentsFactory fragmentsFactory) {
        super(i18nService, refService, permissionService, projectService, repositoryService, scmService, commitService, fragmentsFactory);
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView compare(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @RequestParam(value="sourceBranch", required=false) String fromBranch, @RequestParam(value="targetBranch", required=false) String toBranch, @RequestParam(value="targetRepoId", required=false, defaultValue="-1") int targetRepoId) {
        return this.compareCommits(projectKey, repoSlug, fromBranch, toBranch, targetRepoId);
    }

    @RequestMapping(value={"/diff"}, method={RequestMethod.GET})
    public ModelAndView compareDiff(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @RequestParam(value="sourceBranch", required=false) String fromBranch, @RequestParam(value="targetBranch", required=false) String toBranch, @RequestParam(value="targetRepoId", required=false, defaultValue="-1") int targetRepoId) {
        return this.compareView(projectKey, repoSlug, fromBranch, toBranch, targetRepoId, "compare-diff-tab");
    }

    @RequestMapping(value={"/commits"}, method={RequestMethod.GET})
    public ModelAndView compareCommits(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @RequestParam(value="sourceBranch", required=false) String fromBranch, @RequestParam(value="targetBranch", required=false) String toBranch, @RequestParam(value="targetRepoId", required=false, defaultValue="-1") int targetRepoId) {
        return this.compareView(projectKey, repoSlug, fromBranch, toBranch, targetRepoId, "compare-commits-tab");
    }

    private ModelAndView compareView(String projectKey, String repoSlug, String fromBranch, String toBranch, int targetRepoId, String activeTab) {
        Repository fromRepository = this.getRepository(projectKey, repoSlug);
        if (this.isEmptyRepository(fromRepository)) {
            return this.handleEmptyRepo(fromRepository);
        }
        Repository toRepository = this.getTargetRepository(fromRepository, targetRepoId);
        return ((StashSoyResponseBuilder)this.getCompareViewBuilder(COMPARE_PAGE, fromRepository, fromBranch, toRepository, toBranch).put("activeTab", (Object)activeTab)).build();
    }
}

