/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.markup;

import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositorySupplier;
import com.atlassian.bitbucket.util.AttachmentUri;
import com.atlassian.bitbucket.util.MarkupUtils;
import com.atlassian.markup.renderer.MarkupRendererComponent;
import com.atlassian.markup.renderer.RenderContext;
import com.atlassian.markup.renderer.RenderTransform;
import java.util.Collection;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class AttachmentMarkupRenderer
implements MarkupRendererComponent {
    private final NavBuilder navBuilder;
    private final RepositorySupplier repositorySupplier;

    public AttachmentMarkupRenderer(NavBuilder navBuilder, RepositorySupplier repositorySupplier) {
        this.navBuilder = navBuilder;
        this.repositorySupplier = repositorySupplier;
    }

    @Nonnull
    public RenderTransform process(@Nonnull CharSequence text, @Nonnull RenderContext context) {
        RenderTransform.TransformBuilder builder = RenderTransform.builder();
        Map matches = MarkupUtils.findMatches((CharSequence)text, (Pattern)AttachmentUri.PATTERN, null);
        for (Collection matchResults : matches.values()) {
            for (MatchResult match : matchResults) {
                Repository repository;
                AttachmentUri attachmentUri = AttachmentUri.from((MatchResult)match);
                if (attachmentUri == null || (repository = this.repositorySupplier.getById(attachmentUri.getRepositoryId())) == null) continue;
                String url = this.navBuilder.repo(repository).attachments().attachment(attachmentUri.getAttachmentId()).buildRelNoContext();
                String hostUrl = context.createHostUrl(url);
                builder.add(match.start(), match.end(), hostUrl);
            }
        }
        return builder.build();
    }
}

