/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.fragments;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.atlassian.sal.api.web.context.HttpContext;
import com.atlassian.stash.internal.web.fragments.WebFragmentData;
import com.atlassian.stash.internal.web.fragments.WebItemData;
import com.atlassian.stash.internal.web.fragments.WebPanelData;
import com.atlassian.stash.internal.web.fragments.WebSectionData;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WebFragmentSupport {
    private static final Logger LOG = LoggerFactory.getLogger(WebFragmentSupport.class);
    private static final String INTERNAL_LOCATION = "bitbucket.internal.";
    private static final ImmutableMap<WebFragmentData.Type, String> exampleRequestParamByType = ImmutableMap.builder().put((Object)WebFragmentData.Type.ITEM, (Object)"web.items").put((Object)WebFragmentData.Type.SECTION, (Object)"web.sections").put((Object)WebFragmentData.Type.PANEL, (Object)"web.panels").build();
    private final AuthenticationContext authenticationContext;
    private final DynamicWebInterfaceManager webInterfaceManager;
    private final HttpContext httpContext;

    @Autowired
    public WebFragmentSupport(DynamicWebInterfaceManager webInterfaceManager, AuthenticationContext authenticationContext, HttpContext httpContext) {
        this.authenticationContext = authenticationContext;
        this.webInterfaceManager = webInterfaceManager;
        this.httpContext = httpContext;
    }

    public String formatLocation(String location, WebFragmentData parent) {
        return location.replace("$(key)", parent.getKey());
    }

    public List<WebItemData> getWebItems(String location, Map<String, Object> requestedContext, boolean suppressExamples) {
        HttpServletRequest request = this.httpContext.getRequest();
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("request", request);
        context.put("currentUser", this.authenticationContext.getCurrentUser());
        context.putAll(requestedContext);
        List<WebItemData> webItemDatas = MoreStreams.streamIterable((Iterable)this.webInterfaceManager.getDisplayableWebItems(location, context)).map(WebItemData::new).collect(Collectors.toList());
        if (!suppressExamples && this.shouldIncludeExample(request, WebFragmentData.Type.ITEM, location)) {
            webItemDatas.add(this.createExampleWebItem(location, context));
        }
        return webItemDatas;
    }

    public List<WebSectionData> getWebSections(String location, Map<String, Object> requestedContext, boolean suppressExamples) {
        HttpServletRequest request = this.httpContext.getRequest();
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("request", request);
        context.putAll(requestedContext);
        List<WebSectionData> webSectionData = MoreStreams.streamIterable((Iterable)this.webInterfaceManager.getDisplayableWebSections(location, context)).map(WebSectionData::new).collect(Collectors.toList());
        if (!suppressExamples && this.shouldIncludeExample(request, WebFragmentData.Type.SECTION, location)) {
            webSectionData.add(this.createExampleWebSection(location));
        }
        return webSectionData;
    }

    public List<WebPanelData> getWebPanels(String location, Map<String, Object> requestedContext, boolean suppressExamples) {
        HttpServletRequest request = this.httpContext.getRequest();
        ApplicationUser principal = this.authenticationContext.getCurrentUser();
        ImmutableMap.Builder contextBuilder = ImmutableMap.builder();
        if (request != null) {
            contextBuilder.put((Object)"request", (Object)request);
        }
        if (principal != null) {
            contextBuilder.put((Object)"principal", (Object)principal);
        }
        if (requestedContext != null) {
            contextBuilder.putAll(Maps.filterValues(requestedContext, (Predicate)Predicates.notNull()));
        }
        ImmutableMap context = contextBuilder.build();
        List<WebPanelData> webPanelDatas = MoreStreams.streamIterable((Iterable)this.webInterfaceManager.getDisplayableWebPanelDescriptors(location, (Map)context)).map(arg_0 -> WebFragmentSupport.lambda$getWebPanels$0((Map)context, arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        if (!suppressExamples && this.shouldIncludeExample(request, WebFragmentData.Type.PANEL, location)) {
            webPanelDatas.add(this.createExampleWebPanel(location, (Map)context));
        }
        return webPanelDatas;
    }

    private WebItemData createExampleWebItem(String location, Map<String, Object> context) {
        return new WebItemData("#example-web-item-url", "org.example.plugins:example-web-item", "example-web-item", location, "Web Item: " + location, "Context Items: " + StringUtils.join(context.keySet(), (String)", "), "plugin-point", null, Integer.MAX_VALUE, new HashMap());
    }

    private WebSectionData createExampleWebSection(String location) {
        return new WebSectionData("org.example.plugins:example-web-section", "example-web-section", location, "Web Section: " + location, Integer.MAX_VALUE, new HashMap());
    }

    private WebPanelData createExampleWebPanel(String location, Map<String, Object> context) {
        return new WebPanelData("org.example.plugins:example-web-panel", location, "<div class='plugin-point web-panel'><strong>Web Panel</strong>: " + location + "<br /><strong>Context Items</strong>: " + StringUtils.join(context.keySet(), (String)", ") + "</div>", Integer.MAX_VALUE, new HashMap());
    }

    private boolean shouldIncludeExample(HttpServletRequest request, WebFragmentData.Type type, String location) {
        return request != null && request.getParameter((String)exampleRequestParamByType.get((Object)type)) != null && !location.startsWith(INTERNAL_LOCATION);
    }

    private static /* synthetic */ WebPanelData lambda$getWebPanels$0(Map context, WebPanelModuleDescriptor descriptor) {
        try {
            return WebPanelData.fromDescriptor((WebPanelModuleDescriptor)descriptor, (Map)context);
        }
        catch (RuntimeException e) {
            LOG.warn(String.format("An error occurred rendering %s. Ignoring", descriptor.getCompleteKey()), (Throwable)e);
            return null;
        }
    }
}

