/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.fragments;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.help.HelpPathService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.crowd.manager.recovery.RecoveryModeService;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public class RecoveryModeContextProvider
implements ContextProvider {
    private final AuthenticationContext authenticationContext;
    private final RecoveryModeService recoveryModeService;
    private final HelpPathService helpPathService;

    public RecoveryModeContextProvider(AuthenticationContext authenticationContext, RecoveryModeService recoveryModeService, HelpPathService helpPathService) {
        this.authenticationContext = authenticationContext;
        this.recoveryModeService = recoveryModeService;
        this.helpPathService = helpPathService;
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        HashMap contextMap = Maps.newHashMap(context);
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        boolean recoveryModeOn = this.recoveryModeService.isRecoveryModeOn();
        String recoveryUsername = this.recoveryModeService.getRecoveryUsername();
        contextMap.put("recoveryModeOn", recoveryModeOn);
        if (recoveryModeOn) {
            contextMap.put("recoveryUsername", recoveryUsername);
            contextMap.put("recoveryUserLoggedIn", currentUser != null && recoveryUsername.equals(currentUser.getName()));
            contextMap.put("helpUrl", this.helpPathService.getPageUrl("bitbucket.help.recoverymode"));
            contextMap.put("helpTitle", this.helpPathService.getPageTitle("bitbucket.help.recoverymode"));
        }
        return contextMap;
    }

    public void init(Map<String, String> initParams) throws PluginParseException {
    }
}

