/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.filters;

import com.atlassian.stash.internal.web.filters.SpringSiteMeshFilter;
import com.opensymphony.sitemesh.DecoratorSelector;
import com.opensymphony.sitemesh.webapp.SiteMeshFilter;
import com.opensymphony.sitemesh.webapp.SiteMeshWebAppContext;
import java.lang.reflect.Field;
import javax.servlet.FilterConfig;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="sitemesh")
public class SpringSiteMeshFilter
extends SiteMeshFilter {
    private final DecoratorSelector decoratorSelector;

    @Autowired
    public SpringSiteMeshFilter(DecoratorSelector decoratorSelector) {
        this.decoratorSelector = decoratorSelector;
    }

    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        this.disableSiteMeshExceptionLogging();
    }

    protected DecoratorSelector initDecoratorSelector(SiteMeshWebAppContext webAppContext) {
        return this.decoratorSelector;
    }

    private void disableSiteMeshExceptionLogging() {
        String fieldName = "containerTweaks";
        try {
            Field containerTweaks = SiteMeshFilter.class.getDeclaredField(fieldName);
            containerTweaks.setAccessible(true);
            containerTweaks.set(this, new NoLogContainerTweaks(this));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LoggerFactory.getLogger(this.getClass()).warn("Could not set {} in {}. Additional logging will not be suppressed.", (Object)fieldName, (Object)this.getClass().getSimpleName());
        }
    }
}

