/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.admin;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.stash.internal.web.repos.ViewRef;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class RepositoryForm {
    private ViewRef defaultBranch;
    private String defaultBranchId;
    private boolean forkable;
    private String name;
    private String scmId;

    public RepositoryForm() {
    }

    public RepositoryForm(Repository repository, ViewRef defaultBranch) {
        this.defaultBranch = defaultBranch;
        this.forkable = repository.isForkable();
        this.name = repository.getName();
        this.scmId = repository.getScmId();
    }

    public ViewRef getDefaultBranch() {
        return this.defaultBranch;
    }

    public String getDefaultBranchId() {
        return this.defaultBranchId;
    }

    @RequiredString(size=128, regexp="[\\p{Alnum}][\\w\\-\\. ]*", message="{com.atlassian.bitbucket.validation.repository.name.pattern.message}")
    public String getName() {
        return this.name;
    }

    @Nonnull
    @RequiredString
    public String getScmId() {
        return this.scmId;
    }

    public boolean isForkable() {
        return this.forkable;
    }

    public void setDefaultBranch(ViewRef defaultBranch) {
        this.defaultBranch = defaultBranch;
    }

    public void setDefaultBranchId(String defaultBranchId) {
        this.defaultBranchId = defaultBranchId;
    }

    public void setForkable(boolean forkable) {
        this.forkable = forkable;
    }

    public void setName(String name) {
        this.name = StringUtils.trimToNull((String)name);
    }

    public void setScmId(String scmId) {
        this.scmId = scmId;
    }
}

