/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.admin;

import com.atlassian.bitbucket.validation.annotation.OptionalString;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.bitbucket.validation.groups.Create;
import com.atlassian.bitbucket.validation.groups.Update;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ProjectForm {
    private String avatar;
    private String description;
    private String key;
    private String name;

    public String getAvatar() {
        return StringUtils.trimToNull((String)this.avatar);
    }

    @OptionalString(size=255)
    public String getDescription() {
        return this.description;
    }

    @Pattern(regexp="[a-zA-Z][a-zA-Z0-9_\\-]*", groups={Create.class, Update.class}, message="{com.atlassian.bitbucket.validation.project.key.pattern.message}")
    @RequiredString(size=128)
    public String getKey() {
        return this.key;
    }

    @Pattern(regexp="^[^~].*", groups={Create.class, Update.class}, message="{com.atlassian.bitbucket.validation.project.name.pattern.message}")
    @RequiredString(size=128)
    public String getName() {
        return this.name;
    }

    public boolean hasAvatar() {
        return StringUtils.isNotBlank((CharSequence)this.avatar);
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public void setDescription(String description) {
        this.description = StringUtils.trimToNull((String)description);
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setName(String name) {
        this.name = name;
    }
}

