/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.admin;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.stash.internal.config.log.InternalLoggingService;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.internal.server.ProfilingService;
import com.atlassian.stash.internal.web.admin.LoggingController;
import com.atlassian.stash.internal.web.auth.IgnoresXsrf;
import com.atlassian.stash.internal.web.logging.RestProfiling;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Controller;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/admin"})
public class LoggingController {
    public static final String PATH_LOGGING = "logging";
    public static final String PATH_PROFILING = "profiling";
    private static final String VIEW = "bitbucket.internal.admin.logging";
    private final InternalApplicationPropertiesService applicationPropertiesService;
    private final I18nService i18nService;
    private final InternalLoggingService loggingService;
    private final PermissionService permissionService;
    private final ProfilingService profilingService;

    @Autowired
    public LoggingController(InternalApplicationPropertiesService applicationPropertiesService, I18nService i18nService, InternalLoggingService loggingService, PermissionService permissionService, ProfilingService profilingService) {
        this.applicationPropertiesService = applicationPropertiesService;
        this.i18nService = i18nService;
        this.loggingService = loggingService;
        this.permissionService = permissionService;
        this.profilingService = profilingService;
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"}, value={"profiling"})
    public ResponseEntity<RestProfiling> getProfiling() {
        if (!this.permissionService.hasGlobalPermission(Permission.ADMIN)) {
            throw new AccessDeniedException(this.i18nService.getMessage("bitbucket.web.config.logging.adminonly", new Object[0]));
        }
        boolean enabled = this.profilingService.isEnabled();
        return new ResponseEntity((Object)new RestProfiling(enabled), null, HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.POST}, consumes={"application/json"}, value={"profiling"})
    @IgnoresXsrf
    public ResponseEntity<String> setProfiling(@RequestBody String json) {
        if (!this.permissionService.hasGlobalPermission(Permission.ADMIN)) {
            throw new AccessDeniedException(this.i18nService.getMessage("bitbucket.web.config.logging.adminonly", new Object[0]));
        }
        try {
            RestProfiling restProfiling = (RestProfiling)RestProfiling.createFromJson((String)json, RestProfiling.class);
            if (restProfiling.getEnabled()) {
                this.profilingService.enable();
            } else {
                this.profilingService.disable();
            }
            return new ResponseEntity(null, null, HttpStatus.ACCEPTED);
        }
        catch (IOException e) {
            return new ResponseEntity(null, null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"logging"})
    public ModelAndView showLoggingSettings() {
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(VIEW).put("settings", (Object)this.loadSettings())).put("logFileName", (Object)"atlassian-bitbucket.log")).put("profilerLogFileName", (Object)"atlassian-bitbucket-profiler.log")).build();
    }

    @RequestMapping(method={RequestMethod.POST}, value={"logging"})
    public ModelAndView update(Form form, Errors errors, RedirectAttributes redirectAttributes) {
        this.applicationPropertiesService.setDebugLoggingEnabled(form.isEnableDebugLogging());
        this.applicationPropertiesService.setProfilingEnabled(form.isEnableProfiling());
        if (form.isEnableProfiling()) {
            this.profilingService.enable();
        } else {
            this.profilingService.disable();
        }
        if (form.isEnableDebugLogging()) {
            this.loggingService.enableDebugLogging();
        } else {
            this.loggingService.disableDebugLogging();
        }
        redirectAttributes.addFlashAttribute("saved", (Object)true);
        return new StashSoyResponseBuilder("redirect:/admin/logging").build();
    }

    private Form loadSettings() {
        return new Form(this.applicationPropertiesService.isProfilingEnabled(), this.applicationPropertiesService.isDebugLoggingEnabled());
    }
}

