/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.admin;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.license.LicenseException;
import com.atlassian.bitbucket.license.LicenseService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.extras.api.bitbucket.BitbucketServerLicense;
import com.atlassian.stash.internal.web.setup.LicenseForm;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Controller;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/admin/license"})
public class LicenseController {
    public static final String VIEW = "bitbucket.internal.admin.license";
    public static final String EDIT_VIEW = "bitbucket.internal.admin.licenseedit";
    private final I18nService i18nService;
    private final LicenseService licenseService;
    private final PermissionService permissionService;
    private final ApplicationPropertiesService propertiesService;

    @Autowired
    public LicenseController(I18nService i18nService, LicenseService licenseService, PermissionService permissionService, ApplicationPropertiesService propertiesService) {
        this.i18nService = i18nService;
        this.licenseService = licenseService;
        this.permissionService = permissionService;
        this.propertiesService = propertiesService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView showLicense() {
        BitbucketServerLicense license = this.licenseService.get();
        KeyedMessage overLimitMessage = this.licenseService.getOverLimitMessage();
        StashSoyResponseBuilder builder = (StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(VIEW).put("serverId", (Object)this.propertiesService.getServerId())).put("license", (Object)license)).put("canEdit", (Object)this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN));
        if (overLimitMessage != null) {
            builder.put("overLimitMessage", (Object)overLimitMessage.getLocalisedMessage());
        }
        if (license != null && !license.isUnlimitedNumberOfUsers()) {
            int userCount = this.licenseService.getLicensedUsersCount();
            ((StashSoyResponseBuilder)builder.put("licenseExceeded", (Object)(userCount > license.getMaximumNumberOfUsers() ? 1 : 0))).put("userCount", (Object)userCount);
        }
        return builder.build();
    }

    @RequestMapping(method={RequestMethod.GET}, params={"edit"})
    public ModelAndView showEditLicense() {
        if (!this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN)) {
            throw new AccessDeniedException(this.i18nService.getMessage("bitbucket.web.license.sysadminonly", new Object[0]));
        }
        return this.createEditLicenseBuilder(new LicenseForm()).build();
    }

    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView editLicense(@Valid LicenseForm form, Errors errors, RedirectAttributes redirectAttributes) {
        if (!this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN)) {
            throw new AccessDeniedException(this.i18nService.getMessage("bitbucket.web.license.sysadminonly", new Object[0]));
        }
        if (errors.hasErrors()) {
            return this.createEditLicenseBuilder(form).putValidationErrors(errors).build();
        }
        BitbucketServerLicense license = this.licenseService.get();
        boolean previouslyClusteringEnabled = license != null && license.isClusteringEnabled();
        try {
            license = this.licenseService.set(form.getLicense());
        }
        catch (LicenseException e) {
            Map<String, List<String>> fieldErrors = Collections.singletonMap("license", Collections.singletonList(e.getLocalizedMessage()));
            return ((StashSoyResponseBuilder)this.createEditLicenseBuilder(form).putFieldErrors(fieldErrors)).build();
        }
        catch (ServiceException e) {
            return ((StashSoyResponseBuilder)this.createEditLicenseBuilder(form).putFormErrors(new String[]{e.getLocalizedMessage()})).build();
        }
        if (!previouslyClusteringEnabled && license.isClusteringEnabled()) {
            redirectAttributes.addFlashAttribute("standaloneToClustered", (Object)true);
        }
        redirectAttributes.addFlashAttribute("saved", (Object)true);
        return new ModelAndView("redirect:/admin/license");
    }

    private StashSoyResponseBuilder createEditLicenseBuilder(LicenseForm form) {
        return (StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(EDIT_VIEW).put("serverId", (Object)this.propertiesService.getServerId())).put("form", (Object)form);
    }
}

