/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.admin;

import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.stash.internal.ApplicationConstants;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/admin/clustering"})
public class ClusteringController {
    public static final String VIEW = "bitbucket.internal.admin.clustering";
    private final ClusterService clusterService;
    private final I18nService i18nService;
    private final PermissionService permissionService;

    @Autowired
    public ClusteringController(ClusterService clusterService, I18nService i18nService, PermissionService permissionService) {
        this.clusterService = clusterService;
        this.i18nService = i18nService;
        this.permissionService = permissionService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView view() {
        if (!this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN)) {
            throw new AccessDeniedException(this.i18nService.getMessage("bitbucket.web.config.clustering.sysadminonly", new Object[0]));
        }
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(VIEW).put("isAvailable", (Object)this.clusterService.isAvailable())).put("isClustered", (Object)this.clusterService.isClustered())).put("clusterInformation", (Object)this.clusterService.getInformation())).put("dcProductName", (Object)ApplicationConstants.DATA_CENTER_PRODUCT_NAME)).build();
    }
}

