/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.admin;

import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.stash.internal.web.admin.AuthenticationController;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import javax.validation.Validator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.Errors;
import org.springframework.validation.beanvalidation.SpringValidatorAdapter;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@RequestMapping(value={"/admin/authentication"})
public class AuthenticationController {
    public static final String VIEW = "bitbucket.internal.admin.authentication";
    private final FeatureManager featureManager;
    private final ApplicationPropertiesService propertiesService;
    private final SpringValidatorAdapter validatorAdapter;

    @Autowired
    public AuthenticationController(ApplicationPropertiesService propertiesService, FeatureManager featureManager, Validator validator) {
        this.featureManager = featureManager;
        this.propertiesService = propertiesService;
        this.validatorAdapter = new SpringValidatorAdapter(validator);
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView showSettings() {
        return ((StashSoyResponseBuilder)new StashSoyResponseBuilder("bitbucket.internal.admin.authentication").put("form", (Object)this.loadAuthSettings())).build();
    }

    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView updateSettings(AuthenticationForm settings, Errors errors, RedirectAttributes redirectAttributes) {
        boolean authCaptchaEnabled = this.featureManager.isEnabled((Feature)StandardFeature.AUTH_CAPTCHA);
        if (authCaptchaEnabled) {
            this.validatorAdapter.validate((Object)settings, errors);
        }
        if (errors.hasErrors()) {
            return ((StashSoyResponseBuilder)new StashSoyResponseBuilder("bitbucket.internal.admin.authentication").put("form", (Object)settings)).putValidationErrors(errors).build();
        }
        this.updateAuthSettings(settings, authCaptchaEnabled);
        redirectAttributes.addFlashAttribute("saved", (Object)true);
        return new StashSoyResponseBuilder("redirect:/admin/authentication").build();
    }

    private AuthenticationForm loadAuthSettings() {
        AuthenticationForm form = new AuthenticationForm();
        AuthenticationForm.access$002((AuthenticationForm)form, (Boolean)this.propertiesService.isAllowPublicSignUp());
        AuthenticationForm.access$102((AuthenticationForm)form, (Boolean)this.propertiesService.isShowCaptchaOnSignUp());
        AuthenticationForm.access$202((AuthenticationForm)form, (String)String.valueOf(this.propertiesService.getMaxCaptchaAttempts()));
        return form;
    }

    private void updateAuthSettings(AuthenticationForm form, boolean authCaptchaEnabled) {
        this.propertiesService.setAllowPublicSignUp(Boolean.TRUE.equals(form.getPublicSignUp()));
        if (Boolean.FALSE.equals(form.getPublicSignUp())) {
            this.propertiesService.setShowCaptchaOnSignUp(false);
        } else {
            this.propertiesService.setShowCaptchaOnSignUp(Boolean.TRUE.equals(form.getCaptchaOnSignUp()));
        }
        if (authCaptchaEnabled) {
            this.propertiesService.setMaxCaptchaAttempts(Integer.parseInt(form.getMaxCaptchaAttempts()));
        }
    }
}

