/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.protocol.http;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.ScmUrlFormatter;
import com.atlassian.bitbucket.scm.ScmUrlRequest;
import com.atlassian.bitbucket.scm.http.RepositoryUrlFragment;
import com.atlassian.stash.internal.web.util.UriEncodingUtils;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Component(value="httpScmUrlFormatter")
@Primary
public class DefaultHttpUrlFormatter
implements ScmUrlFormatter {
    private final boolean includeUsername;

    @Autowired
    public DefaultHttpUrlFormatter(@Value(value="${http.cloneurl.includeusername}") boolean includeUsername) {
        this.includeUsername = includeUsername;
    }

    @Nonnull
    public URI format(@Nonnull ScmUrlRequest request) throws URISyntaxException {
        Repository repository = request.getRepository();
        URI uri = request.getBaseUrl();
        String username = request.hasUser() ? request.getUser().getName() : null;
        String path = RepositoryUrlFragment.fromRepository((Repository)repository).toPath(uri.getPath());
        return new URI(uri.getScheme(), this.includeUsername && this.isShellSafe(username) ? username : null, uri.getHost(), uri.getPort(), path, uri.getQuery(), uri.getFragment());
    }

    private boolean isShellSafe(String username) {
        if (username == null) {
            return false;
        }
        try {
            String encodedForUri = UriEncodingUtils.encodeUserInfo((String)username, (String)"UTF-8");
            String encodedForShell = UriEncodingUtils.encodeComponentForShell((String)username, (String)"UTF-8");
            return encodedForUri.equals(encodedForShell);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

