/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.repository.NoSuchRepositoryException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.scm.AuthenticationState;
import com.atlassian.bitbucket.scm.http.HttpScmRequest;
import com.atlassian.bitbucket.scm.http.HttpScmRequestHandler;
import com.atlassian.bitbucket.scm.http.RepositoryUrlFragment;
import com.atlassian.bitbucket.util.RequestUtils;
import com.atlassian.stash.internal.scm.HttpScmRequestExecutor;
import com.atlassian.stash.internal.scm.http.HttpScmRequestHandlerProvider;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.HttpRequestHandler;

@Component(value="scmServlet")
public class ScmServlet
implements HttpRequestHandler {
    private static final Logger log = LoggerFactory.getLogger(ScmServlet.class);
    private final AuthenticationContext authenticationContext;
    private final HttpScmRequestHandlerProvider handlerProvider;
    private final I18nService i18nService;
    private final NavBuilder navBuilder;
    private final RepositoryService repositoryService;
    private final HttpScmRequestExecutor scmRequestExecutor;

    @Autowired
    public ScmServlet(AuthenticationContext authenticationContext, HttpScmRequestHandlerProvider handlerProvider, I18nService i18nService, NavBuilder navBuilder, RepositoryService repositoryService, HttpScmRequestExecutor scmRequestExecutor) {
        this.authenticationContext = authenticationContext;
        this.handlerProvider = handlerProvider;
        this.i18nService = i18nService;
        this.navBuilder = navBuilder;
        this.repositoryService = repositoryService;
        this.scmRequestExecutor = scmRequestExecutor;
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Optional optionalRequestHandler = this.handlerProvider.getHandler(request);
        if (optionalRequestHandler.isPresent()) {
            HttpScmRequestHandler requestHandler = (HttpScmRequestHandler)optionalRequestHandler.get();
            try {
                Optional optionalScmRequest = requestHandler.create(request, response);
                if (optionalScmRequest.isPresent()) {
                    this.scmRequestExecutor.execute(request, (HttpScmRequest)optionalScmRequest.get());
                    return;
                }
            }
            catch (AuthorisationException | NoSuchRepositoryException e) {
                if (this.authenticationContext.isAuthenticated()) {
                    log.debug(e.getMessage());
                    requestHandler.sendError(this.i18nService.getMessage("bitbucket.scm.no.such.repository", new Object[0]), this.i18nService.getMessage("bitbucket.scm.no.such.repository.detail", new Object[0]), request, response);
                } else {
                    requestHandler.sendAuthenticationError(AuthenticationState.NOT_AUTHENTICATED, this.i18nService.getMessage("bitbucket.scm.not.authenticated", new Object[0]), this.i18nService.getMessage("bitbucket.scm.not.authenticated.detail", new Object[0]), request, response);
                }
                return;
            }
        }
        this.handleUnsupportedRequest(request, response);
    }

    private Optional<Repository> getRepositoryFromPathInfo(String pathInfo) {
        Optional<Repository> result = Optional.ofNullable(RepositoryUrlFragment.fromPathInfo((String)pathInfo)).map(fragment -> this.repositoryService.getBySlug(fragment.getProjectKey(), fragment.getRepositorySlug()));
        if (result.isPresent()) {
            return result;
        }
        return Optional.ofNullable(RepositoryUrlFragment.fromNamespacedPathInfo((String)pathInfo)).map(fragment -> this.repositoryService.getBySlug(fragment.getProjectNamespace(), fragment.getProjectKey(), fragment.getRepositorySlug()));
    }

    private void handleUnsupportedRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (RequestUtils.isUserAgentBrowser((HttpServletRequest)request)) {
            String destination = this.getRepositoryFromPathInfo(request.getPathInfo()).map(repository -> this.navBuilder.repo(repository).buildAbsolute()).orElseGet(() -> ((NavBuilder)this.navBuilder).buildAbsolute());
            response.sendRedirect(destination);
        } else {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.web.scm.invalidrequest", new Object[]{Product.NAME, RequestUtils.getRemoteHost((HttpServletRequest)request)});
            log.debug(message.getRootMessage());
            response.setStatus(501);
            response.getWriter().write(message.getLocalisedMessage());
        }
    }
}

