/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.request.RequestContext;
import com.atlassian.bitbucket.util.RequestLocalCache;
import com.atlassian.cache.Supplier;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceBatchingStateCounter;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.cdn.CDNStrategy;
import com.atlassian.stash.internal.BuildInfo;
import com.atlassian.stash.internal.i18n.LocaleHolder;
import com.atlassian.stash.internal.plugin.I18nStateHasher;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=WebResourceIntegration.class)
@Component(value="webResourceIntegration")
public class WebResourceIntegrationImpl
implements WebResourceIntegration {
    private static final String PROP_CDN_BASE_URL = "cdn.base.url";
    private static final String TMP_DIR_WEB_RESOURCES = "webresources";
    private static final Logger log = LoggerFactory.getLogger(WebResourceIntegrationImpl.class);
    private final BuildInfo buildInfo;
    private final LazyReference<CDNStrategy> cdnStrategy;
    private final LocaleHolder localeHolder;
    private final NavBuilder navBuilder;
    private final PluginAccessor pluginAccessor;
    private final PluginEventManager pluginEventManager;
    private final InternalApplicationPropertiesService propertiesService;
    private final RequestLocalCache<String, Object> requestCache;
    private final WebResourceBatchingStateCounter stateCounter;
    private final I18nService i18nService;
    private final I18nStateHasher i18nStateHasher;

    @Autowired
    public WebResourceIntegrationImpl(BuildInfo buildInfo, I18nService i18nService, LocaleHolder localeHolder, NavBuilder navBuilder, PluginAccessor pluginAccessor, PluginEventManager pluginEventManager, InternalApplicationPropertiesService propertiesService, RequestContext requestContext, WebResourceBatchingStateCounter stateCounter, I18nStateHasher i18nStateHasher) {
        this.buildInfo = buildInfo;
        this.localeHolder = localeHolder;
        this.navBuilder = navBuilder;
        this.pluginAccessor = pluginAccessor;
        this.propertiesService = propertiesService;
        this.stateCounter = stateCounter;
        this.i18nService = i18nService;
        this.pluginEventManager = pluginEventManager;
        this.i18nStateHasher = i18nStateHasher;
        this.requestCache = new RequestLocalCache(requestContext);
        this.cdnStrategy = new /* Unavailable Anonymous Inner Class!! */;
    }

    public Set<String> allowedCondition1Keys() {
        throw new UnsupportedOperationException("This function is not supported");
    }

    public Set<String> allowedTransform1Keys() {
        throw new UnsupportedOperationException("This function is not supported");
    }

    public boolean forbidCondition1AndTransformer1() {
        return false;
    }

    public String getBaseUrl() {
        return this.getBaseUrl(UrlMode.AUTO);
    }

    public String getBaseUrl(UrlMode urlMode) {
        return urlMode == UrlMode.ABSOLUTE ? this.navBuilder.buildAbsolute() : this.navBuilder.buildRelative();
    }

    public PluginAccessor getPluginAccessor() {
        return this.pluginAccessor;
    }

    public PluginEventManager getPluginEventManager() {
        return this.pluginEventManager;
    }

    public Map<String, Object> getRequestCache() {
        Map cacheMap = this.requestCache.asMap();
        if (cacheMap == null) {
            return Maps.newHashMap();
        }
        return cacheMap;
    }

    public String getSystemBuildNumber() {
        return this.buildInfo.getDisplayCommitHash();
    }

    public String getHostApplicationVersion() {
        return this.buildInfo.getBuildVersion();
    }

    public String getSystemCounter() {
        return Long.toString(this.stateCounter.getBatchingStateCounter());
    }

    public String getSuperBatchVersion() {
        return Long.toString(this.stateCounter.getBatchingStateCounter());
    }

    public String getStaticResourceLocale() {
        return this.getLocale().toString();
    }

    public String getI18nStateHash() {
        return this.i18nStateHasher.get();
    }

    public File getTemporaryDirectory() {
        return new File(this.propertiesService.getTempDir(), TMP_DIR_WEB_RESOURCES);
    }

    public CDNStrategy getCDNStrategy() {
        return (CDNStrategy)this.cdnStrategy.get();
    }

    public Locale getLocale() {
        return (Locale)this.requestCache.get((Object)"locale", (Supplier)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Iterable<Locale> getSupportedLocales() {
        return Collections.emptyList();
    }

    public String getI18nRawText(Locale locale, String key) {
        return (String)MoreObjects.firstNonNull((Object)this.i18nService.getMessagePattern(locale, key), (Object)key);
    }

    public String getI18nText(Locale locale, String key) {
        return this.i18nService.getText(locale, key, null, new Object[0]);
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }

    static /* synthetic */ LocaleHolder access$300(WebResourceIntegrationImpl x0) {
        return x0.localeHolder;
    }
}

