/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.nav;

import com.atlassian.bitbucket.event.request.RequestStartedEvent;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserType;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.annotation.NotProfiled;
import com.atlassian.stash.internal.concurrent.StatefulService;
import com.atlassian.stash.internal.concurrent.TransferableState;
import com.atlassian.stash.internal.nav.NavBuilderImpl;
import com.atlassian.stash.internal.project.InternalPersonalProject;
import com.google.common.collect.ImmutableList;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriUtils;

@AvailableToPlugins(value=NavBuilder.class)
@Component(value="navBuilder")
public class NavBuilderImpl
implements NavBuilder,
StatefulService {
    private static final Function<String, String> ENCODE_PATH = component -> {
        try {
            return UriUtils.encodePathSegment((String)component, (String)"UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    };
    private static final String ABOUT = "about";
    private static final String ACTION = "action";
    private static final String ACTIVITY_ID = "activityId";
    private static final String ADMIN = "admin";
    private static final String ANONYMIZE = "anonymize";
    private static final String API = "api";
    private static final String APPLICATION_LINKS = "applinks";
    private static final String ARCHIVE = "archive";
    private static final String AT = "at";
    private static final String ATTACHMENTS = "attachments";
    private static final String AUTHENTICATION = "authentication";
    private static final String AVATARS = "avatars";
    private static final String AVATAR = "avatar";
    private static final String AVATAR_EXTENSION = ".png";
    private static final String BOTS = "bots";
    private static final String BRANCHES = "branches";
    private static final String BROWSE = "browse";
    private static final String CAPTCHA = "captcha";
    private static final String CLUSTERING = "clustering";
    private static final String COMMENT_ID = "commentId";
    private static final String COMMITS = "commits";
    private static final String COMPARE = "compare";
    private static final String CREATE = "create";
    private static final String DB = "db";
    private static final String DELETE = "delete";
    private static final String DIFF = "diff";
    private static final String DIRECTION = "direction";
    private static final String EDIT = "edit";
    private static final String EMBEDDED = "embedded";
    private static final String FORK = "fork";
    private static final String FORKS = "forks";
    private static final String GROUPS = "groups";
    private static final String HOOKS = "hooks";
    private static final String I18N = "i18n";
    private static final String LICENSE = "license";
    private static final String LIMIT = "limit";
    private static final String LIST_APPLICATION_LINKS = "listApplicationLinks";
    private static final String LOGIN = "login";
    private static final String LOGGING = "logging";
    private static final String MAIL_SERVER = "mail-server";
    private static final String MERGE_CHECKS = "merge-checks";
    private static final String MERGE_STRATEGIES = "merge-strategies";
    private static final String MVC = "mvc";
    private static final String NOTIFICATION = "notification";
    private static final String OAUTH = "oauth";
    private static final String OVERVIEW = "overview";
    private static final String PASSWORDRESET = "passwordreset";
    private static final String PERMISSIONS = "permissions";
    private static final String PLUGINS = "plugins";
    private static final String PROFILE = "profile";
    private static final String PROJECTS = "projects";
    private static final String PULL_REQUESTS = "pull-requests";
    private static final String REPOS = "repos";
    private static final String REPOSITORIES = "repositories";
    private static final String REST = "rest";
    private static final String RETRIEVE_PASSWORD = "retrievePassword";
    private static final String SECURITY = "security";
    private static final String SERVER_SETTINGS = "server-settings";
    private static final String SERVLET = "servlet";
    private static final String SETTINGS = "settings";
    private static final String SETUP = "setup";
    private static final String SIGNUP = "signup";
    private static final String SSH_SECTION_HASH = "ssh";
    private static final String START = "start";
    private static final String STATE = "state";
    private static final String SYSTEM_INFO = "system-info";
    private static final String TAGS = "tags";
    private static final String TMP = "tmp";
    private static final String TOKENS = "access-tokens";
    private static final String UNREVIEWED = "unreviewed";
    private static final String UNWATCH = "unwatch";
    private static final String UPM = "upm";
    private static final String USERS = "users";
    private static final String VIEW = "view";
    private static final String XSRF_NOTIFICATION = "xsrfNotification";
    private static final String GETTING_STARTED = "getting-started";
    private static final String ACCOUNT = "account";
    private static final String PASSWORD = "password";
    private static final String DASHBOARD = "dashboard";
    private static final Logger log = LoggerFactory.getLogger(NavBuilderImpl.class);
    private final ApplicationPropertiesService applicationPropertiesService;
    private final ThreadLocal<RequestConfiguration> requestConfiguration;

    @Autowired
    public NavBuilderImpl(ApplicationPropertiesService applicationPropertiesService) {
        this.applicationPropertiesService = applicationPropertiesService;
        this.requestConfiguration = new ThreadLocal();
    }

    @EventListener
    public void onRequestStarted(RequestStartedEvent event) {
        if (event.isHttp()) {
            URI uri;
            HttpServletRequest request = (HttpServletRequest)event.getRequestContext().getRawRequest();
            try {
                int port = request.getServerPort();
                if ("http".equals(request.getScheme()) && port == 80 || "https".equals(request.getScheme()) && port == 443) {
                    port = -1;
                }
                uri = new URI(request.getScheme(), null, request.getServerName(), port, request.getContextPath(), null, null);
            }
            catch (URISyntaxException e) {
                log.error("Failed to construct a URI for the NavBuilder from the current requests. Defaulting to application properties.", (Throwable)e);
                uri = this.getBaseUrl();
            }
            String requestUrl = request.getRequestURI();
            String queryString = request.getQueryString();
            this.requestConfiguration.set(new RequestConfiguration(uri, "true".equals(request.getParameter("useBaseUrlToken")), requestUrl, queryString));
            event.getRequestContext().addCleanupCallback(this.requestConfiguration::remove);
        }
    }

    private URI buildBaseUri() {
        RequestConfiguration config = (RequestConfiguration)this.requestConfiguration.get();
        return config != null ? config.getRequestBaseUri() : this.getBaseUrl();
    }

    public String buildBaseUrl() {
        return this.buildBaseUri().toASCIIString();
    }

    protected String buildAbsoluteUrl(URI defaultBaseUrl) {
        RequestConfiguration config = (RequestConfiguration)this.requestConfiguration.get();
        if (config != null && config.isBaseUriTokenRequested()) {
            return "$$$$stash.baseUrl%$$$$";
        }
        if (defaultBaseUrl == null) {
            return null;
        }
        return defaultBaseUrl.toASCIIString();
    }

    public String buildAbsolute() {
        return this.buildAbsoluteUrl(this.buildBaseUri());
    }

    public String buildConfigured() {
        URI baseUrl = this.getBaseUrl();
        return this.buildAbsoluteUrl(baseUrl != null ? baseUrl : this.buildBaseUri());
    }

    public String buildRelative() {
        return this.buildBaseUri().getRawPath();
    }

    @Nonnull
    @NotProfiled
    public TransferableState getState() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public NavBuilder.Project project(@Nonnull String key) {
        return new ProjectImpl(this, key);
    }

    public NavBuilder.Project project(@Nonnull Project project) {
        return new ProjectImpl(this, project.getKey());
    }

    public NavBuilder.Repo repo(@Nonnull Repository repository) {
        return new RepoImpl(this, repository.getProject().getKey(), repository.getSlug());
    }

    public NavBuilder.Login login() {
        RequestConfiguration config = (RequestConfiguration)this.requestConfiguration.get();
        return new LoginImpl(this, config);
    }

    public NavBuilder.Builder<?> logout() {
        return new SimpleBuilder(this, this.components(new String[]{"j_atl_security_logout"}));
    }

    public NavBuilder.Builder<?> signup() {
        return new SimpleBuilder(this, this.components(new String[]{SIGNUP}));
    }

    public NavBuilder.Builder<?> captcha() {
        return new SimpleBuilder(this, this.components(new String[]{CAPTCHA})).withParam("ts", Long.toString(System.currentTimeMillis()));
    }

    public NavBuilder.Builder<?> retrievePassword() {
        return new SimpleBuilder(this, this.components(new String[]{LOGIN, RETRIEVE_PASSWORD}));
    }

    public NavBuilder.Builder<?> passwordReset() {
        return new SimpleBuilder(this, this.components(new String[]{PASSWORDRESET}));
    }

    public NavBuilder.Profile profile() {
        return new CurrentUserProfileImpl(this);
    }

    public NavBuilder.Profile userBySlug(String slug, UserType type) {
        return type == UserType.SERVICE ? new ServiceUserProfileImpl(this, slug) : new UserProfileImpl(this, slug);
    }

    public NavBuilder.Profile user(ApplicationUser user) {
        return user.getType() == UserType.SERVICE ? new ServiceUserProfileImpl(this, user.getSlug()) : new UserProfileImpl(this, user.getSlug());
    }

    public NavBuilder.Builder<?> securityCheck() {
        return new SimpleBuilder(this, this.components(new String[]{"j_atl_security_check"}));
    }

    public NavBuilder.Builder<?> xsrfNotification() {
        return new SimpleBuilder(this, this.components(new String[]{MVC, XSRF_NOTIFICATION}));
    }

    public NavBuilder.ListProjects allProjects() {
        return new ListProjectsImpl(this);
    }

    public NavBuilder.GlobalListRepos allRepos() {
        return new GlobalListReposImpl(this);
    }

    public NavBuilder.CreateProject createProject() {
        return new CreateProjectImpl(this);
    }

    public NavBuilder.UserAccount account() {
        return new UserAccountImpl(this);
    }

    public NavBuilder.Admin admin() {
        return new AdminImpl(this);
    }

    public NavBuilder.Builder<?> about() {
        return new SimpleBuilder(this, this.components(new String[]{ABOUT}));
    }

    public NavBuilder.PluginServlets pluginServlets() {
        return new PluginServletsImpl(this);
    }

    public NavBuilder.Rest rest() {
        return new RestImpl(this);
    }

    public NavBuilder.Builder<?> setup() {
        return new SimpleBuilder(this, this.components(new String[]{SETUP}));
    }

    public NavBuilder.Tmp tmp() {
        return new TmpImpl(this, null);
    }

    @Nonnull
    public NavBuilder.Addons addons() {
        return new AddonsImpl(this, null);
    }

    public NavBuilder.GettingStarted gettingStarted() {
        return new GettingStartedImpl(this, (RequestConfiguration)this.requestConfiguration.get());
    }

    public NavBuilder.Dashboard dashboard() {
        return new DashboardImpl(this, null);
    }

    private List<String> append(List<String> components, String ... others) {
        return ImmutableList.builder().addAll(components).add((Object[])others).build();
    }

    private List<String> components(String ... others) {
        return Arrays.asList(others);
    }

    private List<String> restComponents(String ... others) {
        return this.append(Arrays.asList(REST, API, "1.0"), others);
    }

    private List<String> adminComponents(String ... others) {
        return this.append(Collections.singletonList(ADMIN), others);
    }

    private List<String> databaseComponents(String ... others) {
        return this.append(Arrays.asList(ADMIN, DB), others);
    }

    private List<String> licensingComponents(String ... others) {
        return this.append(Arrays.asList(ADMIN, LICENSE), others);
    }

    private List<String> usersComponents(String ... others) {
        return this.append(Arrays.asList(ADMIN, USERS), others);
    }

    private List<String> groupsComponents(String ... others) {
        return this.append(Arrays.asList(ADMIN, GROUPS), others);
    }

    private List<String> pluginsServletComponents(String ... others) {
        return this.append(Arrays.asList(PLUGINS, SERVLET), others);
    }

    private List<String> projectsComponents() {
        return Collections.singletonList(PROJECTS);
    }

    private List<String> projectComponents(String projectKey, String ... others) {
        return this.projectComponents(false, projectKey, others);
    }

    private List<String> projectComponents(boolean usePersonalProjectPath, String projectKey, String ... others) {
        if (InternalPersonalProject.isPersonalProjectKey((String)projectKey) && usePersonalProjectPath) {
            return ImmutableList.builder().add((Object[])new String[]{USERS, InternalPersonalProject.getPersonalProjectOwner((String)projectKey)}).add((Object[])others).build();
        }
        return ImmutableList.builder().addAll((Iterable)this.projectsComponents()).add((Object)projectKey).add((Object[])others).build();
    }

    private List<String> repoComponents(String projectKey, String repoSlug, String ... others) {
        return this.append(this.projectComponents(true, projectKey, new String[]{REPOS, repoSlug}), others);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URI getBaseUrl() {
        Thread currentThread = Thread.currentThread();
        ClassLoader original = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(NavBuilderImpl.class.getClassLoader());
            URI uRI = this.applicationPropertiesService.getBaseUrl();
            return uRI;
        }
        finally {
            currentThread.setContextClassLoader(original);
        }
    }

    static /* synthetic */ ThreadLocal access$000(NavBuilderImpl x0) {
        return x0.requestConfiguration;
    }

    static /* synthetic */ Function access$400() {
        return ENCODE_PATH;
    }

    static /* synthetic */ List access$500(NavBuilderImpl x0, List x1, String[] x2) {
        return x0.append(x1, x2);
    }

    static /* synthetic */ List access$600(NavBuilderImpl x0, String[] x1) {
        return x0.components(x1);
    }

    static /* synthetic */ List access$700(NavBuilderImpl x0, String[] x1) {
        return x0.adminComponents(x1);
    }

    static /* synthetic */ List access$800(NavBuilderImpl x0, String[] x1) {
        return x0.pluginsServletComponents(x1);
    }

    static /* synthetic */ List access$900(NavBuilderImpl x0, String[] x1) {
        return x0.databaseComponents(x1);
    }

    static /* synthetic */ List access$1000(NavBuilderImpl x0, String[] x1) {
        return x0.licensingComponents(x1);
    }

    static /* synthetic */ List access$1100(NavBuilderImpl x0, String[] x1) {
        return x0.usersComponents(x1);
    }

    static /* synthetic */ List access$1200(NavBuilderImpl x0, String[] x1) {
        return x0.groupsComponents(x1);
    }

    static /* synthetic */ List access$1300(NavBuilderImpl x0, String[] x1) {
        return x0.restComponents(x1);
    }

    static /* synthetic */ List access$1400(NavBuilderImpl x0) {
        return x0.projectsComponents();
    }

    static /* synthetic */ List access$1500(NavBuilderImpl x0, String x1, String x2, String[] x3) {
        return x0.repoComponents(x1, x2, x3);
    }

    static /* synthetic */ List access$1600(NavBuilderImpl x0, boolean x1, String x2, String[] x3) {
        return x0.projectComponents(x1, x2, x3);
    }

    static /* synthetic */ List access$1700(NavBuilderImpl x0, String x1, String[] x2) {
        return x0.projectComponents(x1, x2);
    }
}

