/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.lifecycle;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.util.DevModeUtils;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.Progress;
import com.atlassian.bitbucket.util.ProgressImpl;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.stash.internal.lifecycle.StartupProgressEvent;
import com.atlassian.stash.internal.spring.AbstractSmartLifecycle;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.commons.io.output.NullWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
public class ServerLifecycle
extends AbstractSmartLifecycle {
    private final ApplicationEventPublisher eventPublisher;
    private final ApplicationPropertiesService propertiesService;
    private final SoyTemplateRenderer templateRenderer;

    @Autowired
    public ServerLifecycle(ApplicationEventPublisher eventPublisher, ApplicationPropertiesService propertiesService, SoyTemplateRenderer templateRenderer) {
        this.eventPublisher = eventPublisher;
        this.propertiesService = propertiesService;
        this.templateRenderer = templateRenderer;
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    public void start() {
        if (!DevModeUtils.isEnabled()) {
            this.warmSoy();
        }
        this.eventPublisher.publishEvent((ApplicationEvent)new StartupProgressEvent((Object)this, (Progress)new ProgressImpl(Product.NAME + " has started successfully", 100)));
        super.start();
    }

    private void warmSoy() {
        String templateName;
        ImmutableMap context;
        if (this.propertiesService.isSetup()) {
            context = ImmutableMap.of((Object)"projectPage", (Object)PageUtils.createEmptyPage((PageRequest)PageUtils.newRequest((int)0, (int)25)));
            templateName = "bitbucket.internal.page.projectList";
        } else {
            context = ImmutableMap.of((Object)"showLicenses", (Object)Boolean.FALSE, (Object)"copyrightStartYear", (Object)2012, (Object)"copyrightEndYear", (Object)2012);
            templateName = "bitbucket.internal.page.about";
        }
        this.eventPublisher.publishEvent((ApplicationEvent)new StartupProgressEvent((Object)this, (Progress)new ProgressImpl("Preparing Soy templates", 95)));
        try {
            this.templateRenderer.render((Appendable)new NullWriter(), "com.atlassian.bitbucket.server.bitbucket-web:server-soy-templates", templateName, (Map)context);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

