/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.johnson;

import com.atlassian.bitbucket.Product;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.ApplicationEventCheck;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.atlassian.stash.internal.home.HomeDirectoryDetails;
import com.atlassian.stash.internal.home.HomeDirectoryResolver;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nonnull;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HomeApplicationEventCheck
implements ApplicationEventCheck {
    private static final Logger log = LoggerFactory.getLogger(HomeApplicationEventCheck.class);

    public void check(@Nonnull JohnsonEventContainer eventContainer, @Nonnull ServletContext servletContext) {
        HomeDirectoryDetails homeDirectoryDetails;
        try {
            homeDirectoryDetails = this.resolveHomeDir();
        }
        catch (IllegalStateException e) {
            this.addError(eventContainer, e.getMessage());
            return;
        }
        Path home = homeDirectoryDetails.getHome();
        if (!Files.exists(home, new LinkOption[0])) {
            String message = this.formatErrorMessage("%1$s %3$s [%2$s] cannot be created or %1$s does not have permission to access it", home, "Home");
            this.addError(eventContainer, message);
            return;
        }
        if (!this.verify(eventContainer, home, "Home")) {
            return;
        }
        Path sharedHome = homeDirectoryDetails.getSharedHome();
        if (!Files.exists(sharedHome, new LinkOption[0])) {
            try {
                Files.createDirectories(sharedHome, new FileAttribute[0]);
            }
            catch (IOException e) {
                this.addError(eventContainer, e.getMessage());
                return;
            }
        }
        this.verify(eventContainer, sharedHome, "Shared Home");
    }

    protected HomeDirectoryDetails resolveHomeDir() {
        return new HomeDirectoryResolver().resolve();
    }

    private boolean verify(JohnsonEventContainer eventContainer, Path dir, String dirName) {
        String messageTemplate = null;
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            messageTemplate = "%1$s %3$s [%2$s] is not a directory";
        } else if (!Files.isReadable(dir)) {
            messageTemplate = "%1$s %3$s [%2$s] exists but is not readable by %1$s";
        } else if (!Files.isWritable(dir)) {
            messageTemplate = "%1$s %3$s [%2$s] exists but is not writable by %1$s";
        } else if (!Files.isExecutable(dir)) {
            messageTemplate = "%1$s %3$s [%2$s] exists but is not accessible by %1$s";
        }
        if (messageTemplate != null) {
            String message = this.formatErrorMessage(messageTemplate, dir, dirName);
            this.addError(eventContainer, message);
        }
        return messageTemplate == null;
    }

    private String formatErrorMessage(String template, Path dir, String dirName) {
        return String.format(template, Product.NAME, dir, dirName);
    }

    private void addError(JohnsonEventContainer eventContainer, String message) {
        log.error(message);
        eventContainer.addEvent(new Event(EventType.get((String)"home"), message, EventLevel.get((String)"fatal")));
    }
}

