/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.johnson;

import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.support.EventExceptionTranslator;
import com.atlassian.stash.internal.cluster.NodePassivationException;
import com.atlassian.stash.internal.db.UnsupportedDatabaseException;
import com.atlassian.stash.internal.home.HomeLockDeniedException;
import com.atlassian.stash.internal.home.HomeLockFailedException;
import com.atlassian.stash.internal.home.HomeValidationException;
import com.atlassian.stash.internal.home.UnsupportedDirectoryOverrideException;
import com.atlassian.stash.internal.jdbc.UnsupportedJdbcUrlException;
import com.atlassian.stash.internal.johnson.handler.EventDetails;
import com.atlassian.stash.internal.johnson.handler.bean.BeanFailureHandler;
import com.atlassian.stash.internal.johnson.handler.bean.ConfigurationMigrationHandler;
import com.atlassian.stash.internal.johnson.handler.bean.DataSourceFailureHandler;
import com.atlassian.stash.internal.johnson.handler.bean.HomeDirectoryMigrationHandler;
import com.atlassian.stash.internal.johnson.handler.bean.LiquibaseFailureHandler;
import com.atlassian.stash.internal.johnson.handler.bean.SessionFactoryFailureHandler;
import com.atlassian.stash.internal.johnson.handler.exception.ConnectionFailureHandler;
import com.atlassian.stash.internal.johnson.handler.exception.ExceptionFailureHandler;
import com.atlassian.stash.internal.johnson.handler.exception.HomeLockFailedHandler;
import com.atlassian.stash.internal.johnson.handler.exception.HomeLockedHandler;
import com.atlassian.stash.internal.johnson.handler.exception.HomeValidationHandler;
import com.atlassian.stash.internal.johnson.handler.exception.NodePassivationHandler;
import com.atlassian.stash.internal.johnson.handler.exception.UnsupportedDatabaseHandler;
import com.atlassian.stash.internal.johnson.handler.exception.UnsupportedDirectoryOverrideHandler;
import com.atlassian.stash.internal.johnson.handler.exception.UnsupportedJdbcUrlHandler;
import com.google.common.collect.ImmutableMap;
import com.zaxxer.hikari.pool.HikariPool;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanCreationException;

/*
 * Exception performing whole class analysis ignored.
 */
public class DefaultEventExceptionTranslator
implements EventExceptionTranslator {
    private static final Map<String, Class<? extends BeanFailureHandler>> BEAN_TO_HANDLER_MAP = new ImmutableMap.Builder().put((Object)"configurationMigration", ConfigurationMigrationHandler.class).put((Object)"dataSourceFactory$created", DataSourceFailureHandler.class).put((Object)"homeDirectoryMigration", HomeDirectoryMigrationHandler.class).put((Object)"liquibase", LiquibaseFailureHandler.class).put((Object)"sessionFactory", SessionFactoryFailureHandler.class).build();
    private static final Map<Class<? extends Throwable>, Class<? extends ExceptionFailureHandler>> EXCEPTION_TO_HANDLER_MAP = ImmutableMap.builder().put(HomeLockDeniedException.class, HomeLockedHandler.class).put(HomeLockFailedException.class, HomeLockFailedHandler.class).put(HomeValidationException.class, HomeValidationHandler.class).put(NodePassivationException.class, NodePassivationHandler.class).put(HikariPool.PoolInitializationException.class, ConnectionFailureHandler.class).put(UnsupportedDatabaseException.class, UnsupportedDatabaseHandler.class).put(UnsupportedDirectoryOverrideException.class, UnsupportedDirectoryOverrideHandler.class).put(UnsupportedJdbcUrlException.class, UnsupportedJdbcUrlHandler.class).build();

    public Event translate(@Nonnull Throwable t) {
        EventDetails details = DefaultEventExceptionTranslator.loadDetails((Throwable)t);
        return details == null ? null : details.toEvent();
    }

    private static EventDetails invokeHandlers(Throwable root, BeanCreationException failedBean) {
        String beanName;
        Class beanHandlerClass;
        EventDetails details = null;
        Class exceptionHandlerClass = (Class)EXCEPTION_TO_HANDLER_MAP.get(root.getClass());
        if (exceptionHandlerClass != null) {
            ExceptionFailureHandler handler = (ExceptionFailureHandler)BeanUtils.instantiate((Class)exceptionHandlerClass);
            details = handler.handle(root);
        }
        if (details == null && failedBean != null && (beanHandlerClass = (Class)BEAN_TO_HANDLER_MAP.get(beanName = StringUtils.substringBefore((String)failedBean.getBeanName(), (String)"#"))) != null) {
            details = ((BeanFailureHandler)BeanUtils.instantiate((Class)beanHandlerClass)).handle(failedBean);
        }
        return details;
    }

    private static EventDetails loadDetails(Throwable root) {
        BeanCreationException failedBean = null;
        while (root.getCause() != null) {
            if (root instanceof BeanCreationException) {
                failedBean = (BeanCreationException)root;
            }
            if (EXCEPTION_TO_HANDLER_MAP.containsKey(root.getClass())) break;
            root = root.getCause();
        }
        return DefaultEventExceptionTranslator.invokeHandlers((Throwable)root, failedBean);
    }
}

