/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.boot.web;

import org.apache.catalina.connector.Connector;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.embedded.tomcat.TomcatConnectorCustomizer;

public abstract class CommonConnectorProperties
implements TomcatConnectorCustomizer {
    private final String prefix;
    private String proxyName;
    private Integer proxyPort;
    private int redirectPort = 443;
    private String scheme;
    private Boolean secure;

    protected CommonConnectorProperties(String prefix) {
        this.prefix = prefix;
    }

    public void customize(Connector connector) {
        if (this.secure == null) {
            this.secure = "https".equalsIgnoreCase(this.scheme);
        }
        if (this.scheme == null) {
            String string = this.scheme = this.secure != false ? "https" : "http";
        }
        if ("http".equals(this.scheme) && this.secure.booleanValue() || "https".equals(this.scheme) && !this.secure.booleanValue()) {
            LoggerFactory.getLogger(CommonConnectorProperties.class).warn("\"{}.scheme={}\" conflicts with \"{}.secure={}\". When \"secure\" is \"{}\", \"scheme\" should be set to \"{}\" (or omitted entirely)", new Object[]{this.prefix, this.scheme, this.prefix, this.secure, this.secure, this.secure != false ? "https" : "http"});
        }
        connector.setProxyName(this.proxyName);
        connector.setProxyPort(this.proxyPort == null ? 0 : this.proxyPort);
        connector.setRedirectPort(this.redirectPort);
        connector.setSecure(this.secure.booleanValue());
        connector.setScheme(this.scheme);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getProxyName() {
        return this.proxyName;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public int getRedirectPort() {
        return this.redirectPort;
    }

    public String getScheme() {
        return this.scheme;
    }

    public Boolean getSecure() {
        return this.secure;
    }

    public void setProxyName(String proxyName) {
        this.proxyName = proxyName;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setRedirectPort(int redirectPort) {
        this.redirectPort = redirectPort;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setSecure(Boolean secure) {
        this.secure = secure;
    }
}

