/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.boot.web;

import com.atlassian.johnson.context.JohnsonContextListener;
import com.atlassian.johnson.spring.lifecycle.LifecycleDelegatingFilterProxy;
import com.atlassian.johnson.spring.lifecycle.LifecycleDispatcherServlet;
import com.atlassian.johnson.spring.lifecycle.LifecycleHttpRequestHandlerServlet;
import com.atlassian.plugin.servlet.ServletModuleContainerServlet;
import com.atlassian.plugin.servlet.filter.FilterLocation;
import com.atlassian.stash.internal.johnson.JohnsonServlet;
import com.atlassian.stash.internal.johnson.filters.BypassableJohnson503Filter;
import com.atlassian.stash.internal.johnson.filters.BypassableJohnsonFilter;
import com.atlassian.stash.internal.lifecycle.StartupManager;
import com.atlassian.stash.internal.spring.lifecycle.LifecycleJohnsonServletFilterModuleContainerFilter;
import com.atlassian.stash.internal.web.ApplicationStatusServlet;
import com.atlassian.stash.internal.web.context.ContextCleanupListener;
import com.atlassian.stash.internal.web.filters.ForbiddenFilter;
import com.atlassian.stash.internal.web.filters.IgnoreWebAsyncManagerFilter;
import com.atlassian.stash.internal.web.filters.PathEncodingFilter;
import com.atlassian.stash.internal.web.filters.StreamGuardFilter;
import com.atlassian.stash.internal.web.startup.StartupServlet;
import com.google.common.collect.ImmutableMap;
import com.hazelcast.web.SessionListener;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionTrackingMode;
import javax.servlet.http.HttpSession;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestContextListener;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.tuckey.web.filters.urlrewrite.UrlRewriteFilter;

public class BitbucketServerInitializer
implements ServletContextInitializer {
    public static final String ATTR_WEB_APPLICATION_CONTEXT = WebApplicationContext.class.getName() + ":Bitbucket";
    private static final EnumSet<DispatcherType> DEFAULT = EnumSet.noneOf(DispatcherType.class);
    private static final String URL_ALL = "/*";
    private static final String URL_DOWNLOAD = "/download/*";
    private static final String URL_GIT = "/git/*";
    private static final String URL_MVC = "/mvc/*";
    private static final String URL_PLUGIN_SERVLETS = "/plugins/servlet/*";
    private static final String URL_REST = "/rest/*";
    private static final String URL_SCM = "/scm/*";
    private final StartupManager startupManager;

    public BitbucketServerInitializer(StartupManager startupManager) {
        this.startupManager = startupManager;
    }

    public void onStartup(ServletContext servletContext) {
        servletContext.setSessionTrackingModes(EnumSet.of(SessionTrackingMode.COOKIE));
        this.addListeners(servletContext);
        this.addFilters(servletContext);
        this.addServlets(servletContext);
    }

    private void addFilters(ServletContext context) {
        FilterRegistration.Dynamic asyncManagerSuppress = context.addFilter("asyncManagerSuppress", (Filter)new IgnoreWebAsyncManagerFilter());
        asyncManagerSuppress.addMappingForUrlPatterns(DEFAULT, true, new String[]{URL_PLUGIN_SERVLETS});
        FilterRegistration.Dynamic requestCharsetFilter = context.addFilter("DefaultCharsetRequestFilter", CharacterEncodingFilter.class);
        requestCharsetFilter.setInitParameter("encoding", "UTF-8");
        requestCharsetFilter.addMappingForUrlPatterns(DEFAULT, true, new String[]{URL_ALL});
        FilterRegistration.Dynamic pathCharsetFilter = context.addFilter("DefaultRequestPathCharsetFilter", PathEncodingFilter.class);
        pathCharsetFilter.setInitParameter("encoding", "UTF-8");
        pathCharsetFilter.addMappingForUrlPatterns(DEFAULT, true, new String[]{URL_SCM, URL_GIT});
        context.addFilter("streamGuardFilter", StreamGuardFilter.class).addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST, DispatcherType.ERROR, DispatcherType.FORWARD), true, new String[]{URL_ALL});
        FilterRegistration.Dynamic hazelcastFilter = this.registerLifecycleFilter(context, "hazelcastFilter");
        hazelcastFilter.setInitParameters((Map)ImmutableMap.of((Object)"map-name", (Object)HttpSession.class.getName(), (Object)"targetFilterLifecycle", (Object)"true"));
        hazelcastFilter.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST, DispatcherType.ERROR), true, new String[]{URL_ALL});
        this.registerLifecycleFilter(context, "requestAttributeFilter").addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST, DispatcherType.ERROR, DispatcherType.FORWARD), true, new String[]{URL_ALL});
        context.addFilter("johnson503", BypassableJohnson503Filter.class).addMappingForUrlPatterns(DEFAULT, true, new String[]{URL_DOWNLOAD, URL_GIT, URL_PLUGIN_SERVLETS, URL_REST, URL_SCM});
        context.addFilter("johnson", BypassableJohnsonFilter.class).addMappingForUrlPatterns(DEFAULT, true, new String[]{URL_ALL});
        this.registerLifecycleFilter(context, "entityMovedFilter").addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD), true, new String[]{URL_ALL});
        this.registerLifecycleFilter(context, "pluginProvidedAuthenticationFilter").addMappingForUrlPatterns(DEFAULT, true, new String[]{URL_ALL});
        this.registerModuleContainerFilters(context, FilterLocation.AFTER_ENCODING);
        this.registerModuleContainerFilters(context, FilterLocation.BEFORE_LOGIN);
        this.registerLifecycleFilter(context, "trustedApplicationsAuthenticationFilter").addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST, DispatcherType.ERROR, DispatcherType.FORWARD), true, new String[]{URL_ALL});
        this.registerLifecycleFilter(context, "goGetFilter").addMappingForUrlPatterns(DEFAULT, true, new String[]{URL_ALL});
        FilterRegistration.Dynamic urlRewriteFilter = context.addFilter("urlRewriteFilter", UrlRewriteFilter.class);
        urlRewriteFilter.setInitParameters((Map)ImmutableMap.of((Object)"confReloadCheckInterval", (Object)"-1", (Object)"statusEnabled", (Object)"false"));
        urlRewriteFilter.addMappingForUrlPatterns(DEFAULT, true, new String[]{URL_ALL});
        this.registerLifecycleFilter(context, "springSecurityFilterChain").addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST, DispatcherType.ERROR, DispatcherType.FORWARD), true, new String[]{URL_ALL});
        this.registerLifecycleFilter(context, "authenticationAttributeFilter").addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST, DispatcherType.ERROR, DispatcherType.FORWARD), true, new String[]{URL_ALL});
        this.registerModuleContainerFilters(context, FilterLocation.BEFORE_DECORATION);
        FilterRegistration.Dynamic sitemesh = this.registerLifecycleFilter(context, "sitemesh");
        sitemesh.setInitParameter("targetFilterLifecycle", "true");
        sitemesh.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD), true, new String[]{URL_PLUGIN_SERVLETS});
        this.registerModuleContainerFilters(context, FilterLocation.BEFORE_DISPATCH);
        this.registerLifecycleFilter(context, "standardResponseHeadersFilter").addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD), true, new String[]{URL_ALL});
        context.addFilter("forbidden-web-inf", ForbiddenFilter.class).addMappingForUrlPatterns(EnumSet.of(DispatcherType.FORWARD), true, new String[]{"/WEB-INF/*"});
    }

    private void addListeners(ServletContext context) {
        JohnsonContextListener.register((ServletContext)context);
        context.addListener(ContextCleanupListener.class);
        context.addListener(RequestContextListener.class);
        context.addListener(SessionListener.class);
    }

    private void addServlets(ServletContext context) {
        context.addServlet("plugins", (Servlet)new ServletModuleContainerServlet()).addMapping(new String[]{URL_PLUGIN_SERVLETS});
        ServletRegistration.Dynamic scmServlet = this.registerLifecycleServlet(context, "scmServlet");
        scmServlet.setAsyncSupported(true);
        scmServlet.addMapping(new String[]{URL_SCM, URL_GIT});
        this.registerLifecycleServlet(context, "fileServerServlet").addMapping(new String[]{URL_DOWNLOAD});
        this.registerLifecycleServlet(context, "streamsEmptyActivityServlet").addMapping(new String[]{"/plugins/servlet/streams", "/rest/activity-stream/1.0/config"});
        context.addServlet("statusServlet", (Servlet)new ApplicationStatusServlet(this.startupManager)).addMapping(new String[]{"/status"});
        context.addServlet("johnsonServlet", (Servlet)new JohnsonServlet()).addMapping(new String[]{"/unavailable"});
        context.addServlet("startupServlet", (Servlet)new StartupServlet(this.startupManager)).addMapping(new String[]{"/system/startup"});
        ServletRegistration.Dynamic springMvc = context.addServlet("springMvc", LifecycleDispatcherServlet.class);
        springMvc.setAsyncSupported(true);
        springMvc.setInitParameters((Map)ImmutableMap.of((Object)"contextConfigLocation", (Object)"classpath:stash-context.xml, classpath:stash-mvc.xml", (Object)"contextInitializerClasses", (Object)"com.atlassian.stash.internal.spring.LifecycleApplicationContextInitializer", (Object)"exceptionTranslatorClass", (Object)"com.atlassian.stash.internal.johnson.DefaultEventExceptionTranslator", (Object)"servletContextAttributeName", (Object)ATTR_WEB_APPLICATION_CONTEXT));
        springMvc.setLoadOnStartup(2);
        springMvc.addMapping(new String[]{URL_MVC});
    }

    private FilterRegistration.Dynamic registerLifecycleFilter(ServletContext context, String name) {
        FilterRegistration.Dynamic filter = context.addFilter(name, LifecycleDelegatingFilterProxy.class);
        filter.setInitParameter("contextAttribute", ATTR_WEB_APPLICATION_CONTEXT);
        return filter;
    }

    private ServletRegistration.Dynamic registerLifecycleServlet(ServletContext context, String name) {
        ServletRegistration.Dynamic servlet = context.addServlet(name, LifecycleHttpRequestHandlerServlet.class);
        servlet.setInitParameter("contextAttribute", ATTR_WEB_APPLICATION_CONTEXT);
        servlet.setLoadOnStartup(1);
        return servlet;
    }

    private void registerModuleContainerFilters(ServletContext context, FilterLocation location) {
        this.registerModuleContainerFilter(context, location, DispatcherType.REQUEST);
        this.registerModuleContainerFilter(context, location, DispatcherType.FORWARD);
        this.registerModuleContainerFilter(context, location, DispatcherType.INCLUDE);
        this.registerModuleContainerFilter(context, location, DispatcherType.ERROR);
    }

    private void registerModuleContainerFilter(ServletContext context, FilterLocation location, DispatcherType dispatcher) {
        String name = ("filter-plugin-dispatcher-" + location + "-" + dispatcher).replace("_", "-").toLowerCase(Locale.US);
        FilterRegistration.Dynamic filter = context.addFilter(name, LifecycleJohnsonServletFilterModuleContainerFilter.class);
        filter.setInitParameters((Map)ImmutableMap.of((Object)"location", (Object)location.name(), (Object)"dispatcher", (Object)dispatcher.name()));
        filter.addMappingForUrlPatterns(EnumSet.of(dispatcher), true, new String[]{URL_ALL});
    }
}

