/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.boot.log;

import com.atlassian.bitbucket.Product;
import com.atlassian.stash.internal.BuildInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildInfoLogger {
    private static final Logger log = LoggerFactory.getLogger(BuildInfoLogger.class);
    private final BuildInfo buildInfo;

    public BuildInfoLogger(BuildInfo buildInfo) {
        this.buildInfo = buildInfo;
    }

    public void start() {
        log.info("Starting " + Product.NAME + " " + this.buildInfo.getBuildVersion() + " (" + this.buildInfo.getDisplayCommitHash() + " built on " + this.buildInfo.getBuildTimestamp() + ")");
        log.info("JVM: " + System.getProperty("java.vm.vendor") + " " + System.getProperty("java.vm.name") + " " + System.getProperty("java.runtime.version"));
    }

    public void stop() {
        log.info("{} {} has shut down", (Object)Product.NAME, (Object)this.buildInfo.getBuildVersion());
    }
}

