/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.boot;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.internal.boot.log.LogbackApplicationListener;
import com.atlassian.stash.internal.ApplicationConstants;
import com.atlassian.stash.internal.home.HomeDirectoryDetails;
import com.atlassian.stash.internal.home.HomeDirectoryResolver;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.Banner;
import org.springframework.boot.DefaultApplicationArguments;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.admin.SpringApplicationAdminJmxAutoConfiguration;
import org.springframework.boot.autoconfigure.jmx.JmxAutoConfiguration;
import org.springframework.boot.autoconfigure.web.EmbeddedServletContainerAutoConfiguration;
import org.springframework.boot.autoconfigure.web.ServerPropertiesAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;

/*
 * Exception performing whole class analysis ignored.
 */
@ImportAutoConfiguration(value={EmbeddedServletContainerAutoConfiguration.class, ServerPropertiesAutoConfiguration.class, JmxAutoConfiguration.class, SpringApplicationAdminJmxAutoConfiguration.class})
@SpringBootApplication
public class BitbucketServerApplication {
    private static final Logger log = LoggerFactory.getLogger(BitbucketServerApplication.class);
    private static ApplicationContext applicationContext;
    private static HomeDirectoryDetails homeDirectoryDetails;

    public static void main(String[] args) {
        DefaultApplicationArguments arguments = new DefaultApplicationArguments(args);
        List commands = arguments.getNonOptionArgs();
        if (commands.isEmpty() || "start".equals(commands.get(0))) {
            BitbucketServerApplication.start((String[])args);
        } else if ("stop".equals(commands.get(0))) {
            BitbucketServerApplication.stop();
        } else {
            log.warn("Unexpected command(s): {}", (Object)commands);
        }
    }

    @Bean
    public HomeDirectoryDetails homeDirectoryDetails() {
        return homeDirectoryDetails;
    }

    private static void createTmpDir() {
        String tmpDir = System.getProperty("java.io.tmpdir");
        if (tmpDir != null) {
            Path tmp = Paths.get(tmpDir, new String[0]);
            try {
                Files.createDirectories(tmp, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException e) {
                if (!Files.isDirectory(tmp, new LinkOption[0])) {
                    log.error("java.io.tmpdir ({}) is not a directory", (Object)tmpDir);
                    System.exit(1);
                }
            }
            catch (IOException e) {
                log.error("java.io.tmpdir ({}) could not be created", (Object)tmpDir, (Object)e);
                System.exit(1);
            }
        }
    }

    private static HomeDirectoryDetails resolveHomeDirectory() {
        try {
            return new HomeDirectoryResolver().resolveAndValidate();
        }
        catch (IllegalStateException e) {
            System.err.println("The " + Product.NAME + " home directory is not valid.");
            System.err.println(e.getMessage());
            System.err.println("Refer to https://confluence.atlassian.com/x/-wG_K for more information.");
            System.exit(1);
            throw e;
        }
    }

    private static void setConfigProperties(HomeDirectoryDetails details) {
        StringBuilder builder = new StringBuilder();
        builder.append("classpath:application-internal.properties").append(",").append("classpath:application-default.properties");
        Path homeDir = details.getHome();
        Path sharedHomeDir = details.getSharedHome();
        if (Files.isRegularFile(sharedHomeDir.resolve("bitbucket.properties"), new LinkOption[0])) {
            builder.append(',').append(sharedHomeDir.toUri()).append(',').append(homeDir.toUri());
        } else {
            Stream.of(sharedHomeDir, homeDir).map(dir -> dir.resolve("stash-config.properties")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).findFirst().ifPresent(legacyConfig -> builder.append(',').append(legacyConfig.toUri()));
        }
        System.setProperty("spring.config.location", builder.toString());
        System.setProperty("spring.config.name", ApplicationConstants.APPLICATION_KEY);
    }

    private static void setSystemProperties() {
        System.setProperty("spring.boot.enableautoconfiguration", "false");
        System.setProperty("com.sun.jndi.ldap.connect.pool.protocol", "plain ssl");
        System.setProperty("com.sun.jndi.ldap.connect.pool.authentication", "none simple DIGEST-MD5");
        System.setProperty("hazelcast.logging.type", "slf4j");
        System.setProperty("mail.mime.decodeparameters", "true");
        System.setProperty("org.apache.catalina.connector.RECYCLE_FACADES", "true");
        System.setProperty("org.apache.catalina.connector.Response.ENFORCE_ENCODING_IN_GET_WRITER", "false");
        System.setProperty("org.apache.jasper.runtime.BodyContentImpl.LIMIT_BUFFER", "true");
    }

    private static void start(String[] args) {
        if (applicationContext == null) {
            homeDirectoryDetails = BitbucketServerApplication.resolveHomeDirectory();
            BitbucketServerApplication.setConfigProperties((HomeDirectoryDetails)homeDirectoryDetails);
            BitbucketServerApplication.setSystemProperties();
            BitbucketServerApplication.createTmpDir();
            SpringApplication application = new SpringApplication(new Object[]{BitbucketServerApplication.class});
            application.addListeners(new ApplicationListener[]{new LogbackApplicationListener()});
            application.setBannerMode(Banner.Mode.LOG);
            application.setDefaultProperties((Map)ImmutableMap.of((Object)"keystore.type", (Object)KeyStore.getDefaultType()));
            applicationContext = application.run(args);
        } else {
            log.warn("Start command received, but {} is already running", (Object)Product.NAME);
        }
    }

    private static void stop() {
        if (applicationContext == null) {
            log.warn("Stop command received, but {} is not running", (Object)Product.NAME);
        } else {
            SpringApplication.exit((ApplicationContext)applicationContext, (ExitCodeGenerator[])new ExitCodeGenerator[0]);
        }
    }
}

