define('bitbucket/internal/feature/pull-request/pull-request-diff', [
    'aui',
    'jquery',
    'lodash',
    'bitbucket/util/navbuilder',
    'bitbucket/internal/feature/commit/tree-and-diff-view',
    'bitbucket/internal/feature/file-content/commit-selector',
    'bitbucket/internal/feature/pull-request/pull-request-history',
    'bitbucket/internal/layout/page-scrolling-manager',
    'bitbucket/internal/model/commit-range',
    'bitbucket/internal/model/file-content-modes',
    'bitbucket/internal/model/path-and-line',
    'bitbucket/internal/model/revision',
    'bitbucket/internal/util/events',
    'exports'
], function(
    AJS,
    $,
    _,
    nav,
    treeAndDiffView,
    CommitSelector,
    pullRequestHistory,
    pageScrollingManager,
    CommitRange,
    FileContentModes,
    PathAndLine,
    Revision,
    events,
    exports
) {

    function bindAddFileCommentHandler(keys) {
        (this.execute ? this : AJS.whenIType(keys)).execute(function() {
            $('.add-file-comment-trigger:first').click();
        });
    }

    function commitChangesUrlBuilder(start, limit, commitRange) {
        return nav.rest()
            .currentRepo()
            .commit(commitRange)
            .changes()
            .withParams({ start : start, limit : limit });
    }

    function commitCommentUrl(commit) {
        return function() {
            return nav.rest()
                .currentRepo()
                .commit(commit.id)
                .comments();
        }
    }

    function commitDiffUrlBuilder(fileChange) {
        return nav.rest()
            .currentRepo()
            .commit(fileChange.commitRange)
            .diff(fileChange);
    }

    function commitSelectorItemUrl(commit, pullRequest) {
        return nav
            .currentRepo()
            .pullRequest(pullRequest)
            .commit(commit.id)
            .build();
    }

    function commitSelectorItemUrlSelf(commit, self) {
        return nav
            .currentRepo()
            .pullRequest(self._pullRequest)
            .commit(commit.id)
            .build();
    };

    function getDiffAndTreeViewOptions(commit, pullRequest, maxChanges, relevantContextLines) {
        var changesUrlBuilder;
        var commentUrlBuilder;
        var diffUrlBuilder;
        var webFragmentLocationPrimary;
        var webFragmentLocationSecondary;

        if (commit) {
            changesUrlBuilder = commitChangesUrlBuilder;
            commentUrlBuilder = commitCommentUrl(commit);
            diffUrlBuilder = commitDiffUrlBuilder;
            webFragmentLocationPrimary = 'bitbucket.pull-request.commit.diff.toolbar.primary';
            webFragmentLocationSecondary = 'bitbucket.pull-request.commit.diff.toolbar.secondary';
        } else {
            commentUrlBuilder = pullRequestCommentUrl(pullRequest);
            diffUrlBuilder = pullRequestDiffUrlBuilder(pullRequest);
            webFragmentLocationPrimary = 'bitbucket.pull-request.diff.toolbar.primary';
            webFragmentLocationSecondary = 'bitbucket.pull-request.diff.toolbar.secondary';
        }

        return {
            commentMode : treeAndDiffView.commentMode.CREATE_NEW,
            maxChanges : maxChanges,
            relevantContextLines : relevantContextLines,
            toolbarWebFragmentLocationPrimary : webFragmentLocationPrimary,
            toolbarWebFragmentLocationSecondary : webFragmentLocationSecondary,
            changesUrlBuilder : changesUrlBuilder,
            diffUrlBuilder : diffUrlBuilder,
            commentUrlBuilder : commentUrlBuilder
        }
    }

    function pullRequestCommentUrl(pullRequest) {
        return function() {
            return nav.rest()
                .currentRepo()
                .pullRequest(pullRequest.getId())
                .comments();
        }
    }

    function pullRequestDiffUrlBuilder(pullRequest) {
        return function(fileChange) {
            return nav.rest()
                .currentRepo()
                .pullRequest(pullRequest.id)
                .diff(fileChange);
        }
    }

    var stopAccepting;
    exports.init = function(commit, pullRequest, maxChanges, relevantContextLines) {

        events.on('bitbucket.internal.keyboard.shortcuts.pullrequest.addCommentHandler', bindAddFileCommentHandler);
        stopAccepting = pageScrollingManager.acceptScrollForwardingRequests();

        var commitRange;

        if (commit) {
            commitRange = new CommitRange({
                pullRequest : pullRequest,
                untilRevision : commit,
                sinceRevision : commit.hasParents() ?
                    commit.getParents()[0] :
                    undefined
            });

            // Analytics event: stash.client.pullRequest.commitDiff.view
            events.trigger('bitbucket.internal.feature.pullRequest.commitDiff.view');
        } else {
            commitRange = new CommitRange({ pullRequest : pullRequest });
        }

        treeAndDiffView.init(commitRange, getDiffAndTreeViewOptions(commit, pullRequest, maxChanges, relevantContextLines));
        pullRequestHistory.init();

        var commitSelectorOptions = {
            itemTemplate: bitbucket.internal.feature.fileContent.commitSelectorItemMessage,
            itemUrl: commitSelectorItemUrlSelf,
            mode: FileContentModes.DIFF,
            path: new PathAndLine(decodeURI(window.location.hash.substring(1))),
            pullRequest: pullRequest
        };
        this.commitSelector = new CommitSelector($('.file-tree-container').find('.commit-selector-button'), 'commit-selector');
        this.commitSelector.init(_.extend({
            selectedRevisionReference: commit ? commit.getRevisionReference() : null
        }, commitSelectorOptions));

        $(document).on('click', '.file-tree a', function(e){
            var data = {
                'index': this.id.match(/\d+/),
                'keyboard': !(e.originalEvent instanceof MouseEvent)
            };
            // Analytics event: stash.client.pullRequest.diff.fileChange
            events.trigger('bitbucket.internal.feature.pullRequest.diff.fileChange', null, data);
        });

        var self = this;
        events.on('bitbucket.internal.feature.commitselector.commitSelected', function(commit, pullRequest) {
            history.replaceState(null, null, commitSelectorItemUrl(commit, pullRequest));

            var commitRange = new CommitRange({
                pullRequest: pullRequest,
                sinceRevision : new Revision({id: commit.parents[0].id}),
                untilRevision : new Revision({id: commit.id})
            });

            treeAndDiffView.reset();
            treeAndDiffView.init(commitRange, getDiffAndTreeViewOptions(commit, pullRequest, maxChanges, relevantContextLines));
            self.commitSelector.init(_.extend({
                selectedRevisionReference: commit ? new Revision(commit).getRevisionReference() : null
            }, commitSelectorOptions));
        });
    };

    exports.reset = function() {
        events.off('bitbucket.internal.keyboard.shortcuts.pullrequest.addCommentHandler', bindAddFileCommentHandler);
        pullRequestHistory.reset();
        this.commitSelector.destroy();
        var resetDone = treeAndDiffView.reset();
        stopAccepting();
        return resetDone;
    };
});
