define(
    'bitbucket/internal/bbui/search/internal/search-data-provider',
    ["module", "exports", "bitbucket/internal/impl/data-provider/paged", "../../search-common/search-entities", "../../search-common/search-request", "../../search-common/transformer"],
    function (module, exports, _paged, _searchEntities, _searchRequest, _transformer) {
        "use strict";

        Object.defineProperty(exports, "__esModule", {
            value: true
        });

        var _paged2 = _interopRequireDefault(_paged);

        var _searchEntities2 = _interopRequireDefault(_searchEntities);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                default: obj
            };
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        }

        var _createClass = function () {
            function defineProperties(target, props) {
                for (var i = 0; i < props.length; i++) {
                    var descriptor = props[i];
                    descriptor.enumerable = descriptor.enumerable || false;
                    descriptor.configurable = true;
                    if ("value" in descriptor) descriptor.writable = true;
                    Object.defineProperty(target, descriptor.key, descriptor);
                }
            }

            return function (Constructor, protoProps, staticProps) {
                if (protoProps) defineProperties(Constructor.prototype, protoProps);
                if (staticProps) defineProperties(Constructor, staticProps);
                return Constructor;
            };
        }();

        function _possibleConstructorReturn(self, call) {
            if (!self) {
                throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
            }

            return call && (typeof call === "object" || typeof call === "function") ? call : self;
        }

        function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
            }

            subClass.prototype = Object.create(superClass && superClass.prototype, {
                constructor: {
                    value: subClass,
                    enumerable: false,
                    writable: true,
                    configurable: true
                }
            });
            if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
        }

        var SearchDataProvider = function (_PagedDataProviderSPI) {
            _inherits(SearchDataProvider, _PagedDataProviderSPI);

            function SearchDataProvider(options, initialData) {
                _classCallCheck(this, SearchDataProvider);

                return _possibleConstructorReturn(this, Object.getPrototypeOf(SearchDataProvider).call(this, options, initialData));
            }

            _createClass(SearchDataProvider, [{
                key: "_fetch",
                value: function _fetch(searchRequest) {
                    return this.options.search(searchRequest);
                }
            }, {
                key: "_transform",
                value: function _transform(result) {
                    var _this2 = this;

                    return result[this.options.type].values.map(function (value) {
                        if (_this2.options.type === _searchEntities2.default.CODE) {
                            return (0, _transformer.transformCodeResult)(value);
                        }
                        console.warn("Unknown result type " + _this2.options.type + " in dataProvider transform");
                    });
                }
            }, {
                key: "_validate",
                value: function _validate() {
                    return true;
                }
            }, {
                key: "_fetchNext",
                value: function _fetchNext(lastResponseData) {
                    var searchRequest = void 0;

                    if (lastResponseData) {
                        searchRequest = (0, _searchRequest.nextSearchFor)(this.options.query, this.options.type, this.options.limits, lastResponseData);
                    } else {
                        searchRequest = (0, _searchRequest.searchFor)(this.options.query, this.options.limits);
                    }
                    return this._fetch(searchRequest);
                }
            }, {
                key: "_reachedEnd",
                value: function _reachedEnd(lastResponseData) {
                    return lastResponseData[this.options.type].isLastPage;
                }
            }]);

            return SearchDataProvider;
        }(_paged2.default);

        exports.default = SearchDataProvider;
        module.exports = exports['default'];
    }
);