define(
    'bitbucket/internal/bbui/search-common/search-request',
    ['exports', 'lodash'],
    function (exports, _lodash) {
        'use strict';

        Object.defineProperty(exports, "__esModule", {
            value: true
        });
        exports.searchFor = searchFor;
        exports.nextSearchFor = nextSearchFor;

        var _lodash2 = _interopRequireDefault(_lodash);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                default: obj
            };
        }

        function _defineProperty(obj, key, value) {
            if (key in obj) {
                Object.defineProperty(obj, key, {
                    value: value,
                    enumerable: true,
                    configurable: true,
                    writable: true
                });
            } else {
                obj[key] = value;
            }

            return obj;
        }

        function searchFor(query, requestedEntities, limits) {
            var entities = {};
            _lodash2.default.each(requestedEntities, function (key) {
                entities[key] = {};
            });

            return {
                query: query,
                entities: entities,
                limits: limits
            };
        }

        function nextSearchFor(query, type, limits, previousResult) {
            var entities = _defineProperty({}, type, {
                start: previousResult[type].nextStart,
                limit: limits.primary
            });

            return {
                query: query,
                entities: entities
            };
        }
    }
);