define(
    'bitbucket/internal/bbui/reviewer-avatar',
    ['module', 'exports', 'lodash', 'react', './aui-react/avatar', './models'],
    function (module, exports, _lodash, _react, _avatar, _models) {
        'use strict';

        Object.defineProperty(exports, "__esModule", {
            value: true
        });

        var _lodash2 = _interopRequireDefault(_lodash);

        var _avatar2 = _interopRequireDefault(_avatar);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                default: obj
            };
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        }

        var _createClass = function () {
            function defineProperties(target, props) {
                for (var i = 0; i < props.length; i++) {
                    var descriptor = props[i];
                    descriptor.enumerable = descriptor.enumerable || false;
                    descriptor.configurable = true;
                    if ("value" in descriptor) descriptor.writable = true;
                    Object.defineProperty(target, descriptor.key, descriptor);
                }
            }

            return function (Constructor, protoProps, staticProps) {
                if (protoProps) defineProperties(Constructor.prototype, protoProps);
                if (staticProps) defineProperties(Constructor, staticProps);
                return Constructor;
            };
        }();

        function _possibleConstructorReturn(self, call) {
            if (!self) {
                throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
            }

            return call && (typeof call === "object" || typeof call === "function") ? call : self;
        }

        function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
            }

            subClass.prototype = Object.create(superClass && superClass.prototype, {
                constructor: {
                    value: subClass,
                    enumerable: false,
                    writable: true,
                    configurable: true
                }
            });
            if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
        }

        var propTypes = {
            avatarSize: _react.PropTypes.string,
            reviewer: _react.PropTypes.shape({
                user: _react.PropTypes.object.isRequired,
                state: _react.PropTypes.oneOf(_lodash2.default.values(_models.ApprovalState)).isRequired
            }).isRequired,
            withName: _react.PropTypes.bool,
            tooltip: _react.PropTypes.bool,
            nameOnly: _react.PropTypes.bool
        };

        var visibleBadgeCssClass = {
            APPROVED: 'approved',
            NEEDS_WORK: 'needs-work'
        };

        var avatarBadges = [{
            className: visibleBadgeCssClass.APPROVED,
            text: AJS.I18n.getText('bitbucket.component.avatar.badge.approved')
        }, {
            className: visibleBadgeCssClass.NEEDS_WORK,
            text: AJS.I18n.getText('bitbucket.component.avatar.badge.needs.work')
        }];

        function reviewerTooltip(reviewer, nameOnly) {
            var name = reviewer.user.display_name || reviewer.user.name;
            var displayText = void 0;
            if (nameOnly || !reviewer.state || reviewer.state === _models.ApprovalState.UNAPPROVED) {
                displayText = name;
            } else if (reviewer.state === _models.ApprovalState.APPROVED) {
                displayText = AJS.I18n.getText('bitbucket.component.pull.request.reviewer.tooltip.approved', name);
            } else {
                displayText = AJS.I18n.getText('bitbucket.component.pull.request.reviewer.tooltip.needs.work', name);
            }
            return displayText;
        }

        var ReviewerAvatar = function (_Component) {
            _inherits(ReviewerAvatar, _Component);

            function ReviewerAvatar() {
                _classCallCheck(this, ReviewerAvatar);

                return _possibleConstructorReturn(this, Object.getPrototypeOf(ReviewerAvatar).apply(this, arguments));
            }

            _createClass(ReviewerAvatar, [{
                key: 'shouldComponentUpdate',
                value: function shouldComponentUpdate(newProps) {
                    return this.props.reviewer.user.name !== newProps.reviewer.user.name || this.props.reviewer.state !== newProps.reviewer.state || this.props.avatarSize !== newProps.avatarSize || Boolean(this.props.nameOnly) !== Boolean(newProps.nameOnly) || Boolean(this.props.tooltip) !== Boolean(newProps.tooltip) || Boolean(this.props.withName) !== Boolean(newProps.withName);
                }
            }, {
                key: 'render',
                value: function render() {
                    var props = this.props;
                    return React.createElement(_avatar2.default, {
                        person: props.reviewer.user,
                        size: props.avatarSize,
                        badges: avatarBadges,
                        tooltipText: reviewerTooltip(props.reviewer, props.nameOnly),
                        visibleBadge: props.reviewer.state ? visibleBadgeCssClass[props.reviewer.state] : '',
                        withName: props.withName,
                        tooltip: props.tooltip
                    });
                }
            }]);

            return ReviewerAvatar;
        }(_react.Component);

        ReviewerAvatar.propTypes = propTypes;
        exports.default = ReviewerAvatar;
        module.exports = exports['default'];
    }
);