define(
    'bitbucket/internal/bbui/pull-request-table/components/tasks',
    ['module', 'exports', 'react', '../../aui-react/icon', './count-cell'],
    function (module, exports, _react, _icon, _countCell) {
        'use strict';

        Object.defineProperty(exports, "__esModule", {
            value: true
        });

        var _icon2 = _interopRequireDefault(_icon);

        var _countCell2 = _interopRequireDefault(_countCell);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                default: obj
            };
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        }

        var _createClass = function () {
            function defineProperties(target, props) {
                for (var i = 0; i < props.length; i++) {
                    var descriptor = props[i];
                    descriptor.enumerable = descriptor.enumerable || false;
                    descriptor.configurable = true;
                    if ("value" in descriptor) descriptor.writable = true;
                    Object.defineProperty(target, descriptor.key, descriptor);
                }
            }

            return function (Constructor, protoProps, staticProps) {
                if (protoProps) defineProperties(Constructor.prototype, protoProps);
                if (staticProps) defineProperties(Constructor, staticProps);
                return Constructor;
            };
        }();

        function _possibleConstructorReturn(self, call) {
            if (!self) {
                throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
            }

            return call && (typeof call === "object" || typeof call === "function") ? call : self;
        }

        function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
            }

            subClass.prototype = Object.create(superClass && superClass.prototype, {
                constructor: {
                    value: subClass,
                    enumerable: false,
                    writable: true,
                    configurable: true
                }
            });
            if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
        }

        var propTypes = {
            pullRequest: _react.PropTypes.object.isRequired
        };

        var Tasks = function (_Component) {
            _inherits(Tasks, _Component);

            function Tasks() {
                _classCallCheck(this, Tasks);

                return _possibleConstructorReturn(this, Object.getPrototypeOf(Tasks).apply(this, arguments));
            }

            _createClass(Tasks, [{
                key: 'shouldComponentUpdate',
                value: function shouldComponentUpdate(newProps) {
                    return this.props.pullRequest.task_count !== newProps.pullRequest.task_count;
                }
            }, {
                key: 'render',
                value: function render() {
                    var pullRequest = this.props.pullRequest;
                    return React.createElement(_countCell2.default, {
                        count: pullRequest.task_count,
                        tooltip: AJS.I18n.getText('bitbucket.web.tasks.openTaskCount', pullRequest.task_count),
                        className: 'tasks',
                        icon: React.createElement(
                            _icon2.default,
                            { size: 'small', icon: 'editor-task' },
                            AJS.I18n.getText('bitbucket.web.tasks.openTask.label')
                        )
                    });
                }
            }]);

            return Tasks;
        }(_react.Component);

        Tasks.Header = _countCell2.default.Header;
        Tasks.propTypes = propTypes;

        exports.default = Tasks;
        module.exports = exports['default'];
    }
);