define(
    'bitbucket/internal/bbui/pull-request-table/components/reviewers',
    ['module', 'exports', 'lodash', 'react', '../../reviewer-avatar-list'],
    function (module, exports, _lodash, _react, _reviewerAvatarList) {
        'use strict';

        Object.defineProperty(exports, "__esModule", {
            value: true
        });

        var _lodash2 = _interopRequireDefault(_lodash);

        var _reviewerAvatarList2 = _interopRequireDefault(_reviewerAvatarList);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                default: obj
            };
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        }

        var _createClass = function () {
            function defineProperties(target, props) {
                for (var i = 0; i < props.length; i++) {
                    var descriptor = props[i];
                    descriptor.enumerable = descriptor.enumerable || false;
                    descriptor.configurable = true;
                    if ("value" in descriptor) descriptor.writable = true;
                    Object.defineProperty(target, descriptor.key, descriptor);
                }
            }

            return function (Constructor, protoProps, staticProps) {
                if (protoProps) defineProperties(Constructor.prototype, protoProps);
                if (staticProps) defineProperties(Constructor, staticProps);
                return Constructor;
            };
        }();

        function _possibleConstructorReturn(self, call) {
            if (!self) {
                throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
            }

            return call && (typeof call === "object" || typeof call === "function") ? call : self;
        }

        function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
            }

            subClass.prototype = Object.create(superClass && superClass.prototype, {
                constructor: {
                    value: subClass,
                    enumerable: false,
                    writable: true,
                    configurable: true
                }
            });
            if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
        }

        var MAX_OPEN = 3;

        function anyReviewersDifferent(oldReviewers, newReviewers) {
            return oldReviewers.length !== newReviewers.length || _lodash2.default.zip(oldReviewers, newReviewers).some(function (a, b) {
                return a.name !== b.name || a.state !== b.state;
            });
        }

        var Reviewers = function (_Component) {
            _inherits(Reviewers, _Component);

            function Reviewers() {
                _classCallCheck(this, Reviewers);

                return _possibleConstructorReturn(this, Object.getPrototypeOf(Reviewers).apply(this, arguments));
            }

            _createClass(Reviewers, [{
                key: 'shouldComponentUpdate',
                value: function shouldComponentUpdate(newProps) {
                    return this.props.pullRequest.id !== newProps.pullRequest.id || anyReviewersDifferent(this.props.pullRequest.reviewers, newProps.pullRequest.reviewers) || this.props.pullRequest.state !== newProps.pullRequest.state;
                }
            }, {
                key: 'render',
                value: function render() {
                    var pullRequest = this.props.pullRequest;

                    return React.createElement(
                        'td',
                        { className: 'reviewers' },
                        React.createElement(_reviewerAvatarList2.default, {
                            avatarSize: 'small',
                            currentUserAsReviewer: this.props.currentUser,
                            currentUserAvatarSize: this.props.currentUserAvatarSize,
                            dialogReviewersAsTooltip: this.props.dialogReviewersAsTooltip,
                            maxOpen: MAX_OPEN,
                            menuId: 'reviewers-' + pullRequest.id,
                            permissionToReview: false,
                            pullRequestIsOpen: pullRequest.state === 'OPEN',
                            reviewers: pullRequest.reviewers
                        })
                    );
                }
            }], [{
                key: 'propTypes',
                get: function get() {
                    return {
                        currentUser: _react.PropTypes.object,
                        currentUserAvatarSize: _react.PropTypes.string,
                        dialogReviewersAsTooltip: _reviewerAvatarList2.default.propTypes.dialogReviewersAsTooltip,
                        pullRequest: _react.PropTypes.object.isRequired
                    };
                }
            }]);

            return Reviewers;
        }(_react.Component);

        Reviewers.Header = function () {
            return React.createElement(
                'th',
                { className: 'reviewers', scope: 'col' },
                AJS.I18n.getText('bitbucket.pull.request.table.title.reviewers')
            );
        };

        exports.default = Reviewers;
        module.exports = exports['default'];
    }
);