define(
    'bitbucket/internal/bbui/pull-request-list-table/components/summary',
    ['module', 'exports', 'react', 'bitbucket/internal/impl/urls', '../../aui-react/icon', '../../ref-label', '../../time'],
    function (module, exports, _react, _urls, _icon, _refLabel, _time) {
        'use strict';

        Object.defineProperty(exports, "__esModule", {
            value: true
        });

        var _urls2 = _interopRequireDefault(_urls);

        var _icon2 = _interopRequireDefault(_icon);

        var _refLabel2 = _interopRequireDefault(_refLabel);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                default: obj
            };
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        }

        var _createClass = function () {
            function defineProperties(target, props) {
                for (var i = 0; i < props.length; i++) {
                    var descriptor = props[i];
                    descriptor.enumerable = descriptor.enumerable || false;
                    descriptor.configurable = true;
                    if ("value" in descriptor) descriptor.writable = true;
                    Object.defineProperty(target, descriptor.key, descriptor);
                }
            }

            return function (Constructor, protoProps, staticProps) {
                if (protoProps) defineProperties(Constructor.prototype, protoProps);
                if (staticProps) defineProperties(Constructor, staticProps);
                return Constructor;
            };
        }();

        function _possibleConstructorReturn(self, call) {
            if (!self) {
                throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
            }

            return call && (typeof call === "object" || typeof call === "function") ? call : self;
        }

        function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
            }

            subClass.prototype = Object.create(superClass && superClass.prototype, {
                constructor: {
                    value: subClass,
                    enumerable: false,
                    writable: true,
                    configurable: true
                }
            });
            if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
        }

        var propTypes = {
            pullRequest: _react.PropTypes.object.isRequired
        };

        var customMapping = {
            aMomentAgo: function aMomentAgo() {
                return AJS.I18n.getText('bitbucket.pull.request.updated.date.format.a.moment.ago');
            },
            oneMinuteAgo: function oneMinuteAgo() {
                return AJS.I18n.getText('bitbucket.pull.request.updated.date.format.one.minute.ago');
            },
            xMinutesAgo: function xMinutesAgo(param) {
                return AJS.I18n.getText('bitbucket.pull.request.updated.date.format.x.minutes.ago', param);
            },
            oneHourAgo: function oneHourAgo() {
                return AJS.I18n.getText('bitbucket.pull.request.updated.date.format.one.hour.ago');
            },
            xHoursAgo: function xHoursAgo(param) {
                return AJS.I18n.getText('bitbucket.pull.request.updated.date.format.x.hours.ago', param);
            },
            oneDayAgo: function oneDayAgo() {
                return AJS.I18n.getText('bitbucket.pull.request.updated.date.format.one.day.ago');
            },
            xDaysAgo: function xDaysAgo(param) {
                return AJS.I18n.getText('bitbucket.pull.request.updated.date.format.x.days.ago', param);
            },
            oneWeekAgo: function oneWeekAgo() {
                return AJS.I18n.getText('bitbucket.pull.request.updated.date.format.one.week.ago');
            },
            defaultType: function defaultType(param) {
                return AJS.I18n.getText('bitbucket.pull.request.updated.date.format.absolute', param);
            }
        };

        var Summary = function (_Component) {
            _inherits(Summary, _Component);

            function Summary() {
                _classCallCheck(this, Summary);

                return _possibleConstructorReturn(this, Object.getPrototypeOf(Summary).apply(this, arguments));
            }

            _createClass(Summary, [{
                key: 'shouldComponentUpdate',
                value: function shouldComponentUpdate(newProps) {
                    return this.props.pullRequest.id !== newProps.pullRequest.id || this.props.pullRequest.title !== newProps.pullRequest.title || this.props.pullRequest.to_ref.id !== newProps.pullRequest.to_ref.id || this.props.pullRequest.updated_date !== newProps.pullRequest.updated_date;
                }
            }, {
                key: 'render',
                value: function render() {
                    var props = this.props;
                    var pullRequest = props.pullRequest;

                    return React.createElement(
                        'td',
                        { className: 'summary' },
                        React.createElement(
                            'div',
                            { className: 'title-and-target-branch' },
                            React.createElement(
                                'a',
                                { className: 'pull-request-title',
                                    title: pullRequest.title,
                                    href: _urls2.default.pullRequest(pullRequest)
                                },
                                pullRequest.title
                            ),
                            React.createElement(_icon2.default, { size: 'small', icon: 'devtools-arrow-right' }),
                            React.createElement(
                                'span',
                                { className: 'pull-request-target-branch' },
                                React.createElement(_refLabel2.default, { scmRef: pullRequest.to_ref })
                            )
                        ),
                        React.createElement(
                            'div',
                            { className: 'pr-author-number-and-timestamp' },
                            React.createElement(
                                'span',
                                null,
                                pullRequest.author.user.display_name,
                                ' - #',
                                pullRequest.id,
                                ', '
                            ),
                            React.createElement(
                                'time',
                                {
                                    title: (0, _time.format)(pullRequest.updated_date, 'full'),
                                    dateTime: (0, _time.format)(pullRequest.updated_date, 'timestamp')
                                },
                                (0, _time.format)(pullRequest.updated_date, 'shortAge', customMapping)
                            )
                        )
                    );
                }
            }]);

            return Summary;
        }(_react.Component);

        var headerPropTypes = {
            colSpan: _react.PropTypes.number
        };

        var Header = function Header(props) {
            return React.createElement(
                'th',
                { className: 'summary', scope: 'col', colSpan: props.colSpan },
                AJS.I18n.getText('bitbucket.pull.request.table.title.summary')
            );
        };

        Header.propTypes = headerPropTypes;
        Summary.propTypes = propTypes;

        Summary.Header = Header;

        exports.default = Summary;
        module.exports = exports['default'];
    }
);