define(
    'bitbucket/internal/bbui/pull-request-header',
    ['module', 'exports', 'classnames', 'lodash', 'react', './aui-react/avatar', './branch-from-to', './models', './reviewer-avatar-list', './reviewer-status', './pull-request-header/components/merge', './pull-request-header/components/pull-request-more', './pull-request-header/components/reopen-button'],
    function (module, exports, _classnames, _lodash, _react, _avatar, _branchFromTo, _models, _reviewerAvatarList, _reviewerStatus, _merge, _pullRequestMore, _reopenButton) {
        'use strict';

        Object.defineProperty(exports, "__esModule", {
            value: true
        });

        var _classnames2 = _interopRequireDefault(_classnames);

        var _lodash2 = _interopRequireDefault(_lodash);

        var _avatar2 = _interopRequireDefault(_avatar);

        var _branchFromTo2 = _interopRequireDefault(_branchFromTo);

        var _reviewerAvatarList2 = _interopRequireDefault(_reviewerAvatarList);

        var _reviewerStatus2 = _interopRequireDefault(_reviewerStatus);

        var _merge2 = _interopRequireDefault(_merge);

        var _pullRequestMore2 = _interopRequireDefault(_pullRequestMore);

        var _reopenButton2 = _interopRequireDefault(_reopenButton);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                default: obj
            };
        }

        function _defineProperty(obj, key, value) {
            if (key in obj) {
                Object.defineProperty(obj, key, {
                    value: value,
                    enumerable: true,
                    configurable: true,
                    writable: true
                });
            } else {
                obj[key] = value;
            }

            return obj;
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        }

        var _createClass = function () {
            function defineProperties(target, props) {
                for (var i = 0; i < props.length; i++) {
                    var descriptor = props[i];
                    descriptor.enumerable = descriptor.enumerable || false;
                    descriptor.configurable = true;
                    if ("value" in descriptor) descriptor.writable = true;
                    Object.defineProperty(target, descriptor.key, descriptor);
                }
            }

            return function (Constructor, protoProps, staticProps) {
                if (protoProps) defineProperties(Constructor.prototype, protoProps);
                if (staticProps) defineProperties(Constructor, staticProps);
                return Constructor;
            };
        }();

        function _possibleConstructorReturn(self, call) {
            if (!self) {
                throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
            }

            return call && (typeof call === "object" || typeof call === "function") ? call : self;
        }

        function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
            }

            subClass.prototype = Object.create(superClass && superClass.prototype, {
                constructor: {
                    value: subClass,
                    enumerable: false,
                    writable: true,
                    configurable: true
                }
            });
            if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
        }

        var propTypes = {
            conditions: _react.PropTypes.objectOf(_react.PropTypes.bool),
            mergeHelp: _react.PropTypes.object,
            currentUserAsReviewer: _react.PropTypes.object,
            currentUserIsWatching: _react.PropTypes.bool,
            currentUserStatus: _react.PropTypes.oneOf(_lodash2.default.values(_models.ApprovalState)),
            onMergeClick: _react.PropTypes.func.isRequired,
            onReOpenClick: _react.PropTypes.func.isRequired,
            onMergeHelpDialogClose: _react.PropTypes.func,
            onMoreAction: _react.PropTypes.func.isRequired,
            onSelfClick: _react.PropTypes.func.isRequired,
            onStatusClick: _react.PropTypes.func.isRequired,
            pullRequest: _react.PropTypes.object.isRequired,
            permissionToReview: _react.PropTypes.bool.isRequired,
            showMergeHelpDialog: _react.PropTypes.bool
        };

        var REVIEWERS_MAX_OPEN = 4;

        var PullRequestHeader = function (_Component) {
            _inherits(PullRequestHeader, _Component);

            function PullRequestHeader() {
                _classCallCheck(this, PullRequestHeader);

                return _possibleConstructorReturn(this, Object.getPrototypeOf(PullRequestHeader).apply(this, arguments));
            }

            _createClass(PullRequestHeader, [{
                key: 'pullRequestStateReadable',
                value: function pullRequestStateReadable(state) {
                    var _stateToReadable;

                    var stateToReadable = (_stateToReadable = {}, _defineProperty(_stateToReadable, _models.PullRequestState.OPEN, AJS.I18n.getText('bitbucket.component.pull.request.list.state.open')), _defineProperty(_stateToReadable, _models.PullRequestState.DECLINED, AJS.I18n.getText('bitbucket.component.pull.request.list.state.declined')), _defineProperty(_stateToReadable, _models.PullRequestState.MERGED, AJS.I18n.getText('bitbucket.component.pull.request.list.state.merged')), _stateToReadable);
                    return stateToReadable.hasOwnProperty(state) ? stateToReadable[state] : '';
                }
            }, {
                key: 'render',
                value: function render() {
                    var pullRequest = this.props.pullRequest;

                    var pullRequestIsOpen = pullRequest.state === _models.PullRequestState.OPEN;
                    var reOpenButton = void 0;
                    var reviewerStatus = void 0;

                    if (pullRequest.state === _models.PullRequestState.DECLINED && this.props.conditions.canEdit) {
                        reOpenButton = React.createElement(_reopenButton2.default, {
                            onReOpenClick: this.props.onReOpenClick
                        });
                    }

                    if (pullRequestIsOpen) {
                        reviewerStatus = React.createElement(_reviewerStatus2.default, {
                            currentUserAsReviewer: this.props.currentUserAsReviewer,
                            onStatusClick: this.props.onStatusClick,
                            status: this.props.currentUserStatus
                        });
                    }

                    return React.createElement(
                        'div',
                        { className: 'pull-request-header' },
                        React.createElement(
                            'div',
                            { className: 'flexible' },
                            React.createElement(
                                'div',
                                { className: 'pull-request-metadata' },
                                React.createElement(_avatar2.default, {
                                    className: 'author',
                                    person: pullRequest.author,
                                    withName: true,
                                    withLink: true
                                }),
                                React.createElement(_branchFromTo2.default, {
                                    fromRef: pullRequest.from_ref,
                                    toRef: pullRequest.to_ref
                                }),
                                React.createElement('div', { className: 'divider' }),
                                React.createElement(
                                    'div',
                                    { className: (0, _classnames2.default)('status', 'aui-lozenge', {
                                            'aui-lozenge-complete': pullRequest.state === _models.PullRequestState.OPEN,
                                            'aui-lozenge-error': pullRequest.state === _models.PullRequestState.DECLINED,
                                            'aui-lozenge-success': pullRequest.state === _models.PullRequestState.MERGED
                                        })
                                    },
                                    this.pullRequestStateReadable(pullRequest.state)
                                )
                            ),
                            React.createElement(
                                'div',
                                { className: (0, _classnames2.default)('pull-request-actions', { pullRequestIsOpen: pullRequestIsOpen }) },
                                React.createElement(_reviewerAvatarList2.default, {
                                    reviewers: pullRequest.reviewers,
                                    menuId: 'overflow-reviewers',
                                    triggerClass: 'overflow-reviewers-trigger',
                                    maxOpen: REVIEWERS_MAX_OPEN,
                                    avatarSize: 'small',
                                    reverse: true,
                                    onSelfClick: this.props.onSelfClick,
                                    currentUserAsReviewer: this.props.currentUserAsReviewer,
                                    isWatching: this.props.currentUserIsWatching,
                                    permissionToReview: this.props.permissionToReview,
                                    pullRequestIsOpen: pullRequestIsOpen
                                }),
                                reviewerStatus,
                                React.createElement(_merge2.default, {
                                    conditions: this.props.conditions,
                                    mergeHelp: this.props.mergeHelp,
                                    onMergeClick: this.props.onMergeClick,
                                    onMergeHelpDialogClose: this.props.onMergeHelpDialogClose,
                                    pullRequest: pullRequest,
                                    showMergeHelpDialog: this.props.showMergeHelpDialog
                                }),
                                reOpenButton,
                                React.createElement(_pullRequestMore2.default, {
                                    onMoreAction: this.props.onMoreAction,
                                    isWatching: this.props.currentUserIsWatching,
                                    conditions: this.props.conditions,
                                    pullRequest: pullRequest
                                })
                            )
                        ),
                        React.createElement(
                            'h2',
                            null,
                            pullRequest.title
                        )
                    );
                }
            }]);

            return PullRequestHeader;
        }(_react.Component);

        PullRequestHeader.propTypes = propTypes;

        exports.default = PullRequestHeader;
        module.exports = exports['default'];
    }
);