define(
    'bitbucket/internal/bbui/mirroring-admin/nav-builder',
    ['module', 'exports', 'aui'],
    function (module, exports, _aui) {
        'use strict';

        Object.defineProperty(exports, "__esModule", {
            value: true
        });

        var _aui2 = _interopRequireDefault(_aui);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                default: obj
            };
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        }

        var _createClass = function () {
            function defineProperties(target, props) {
                for (var i = 0; i < props.length; i++) {
                    var descriptor = props[i];
                    descriptor.enumerable = descriptor.enumerable || false;
                    descriptor.configurable = true;
                    if ("value" in descriptor) descriptor.writable = true;
                    Object.defineProperty(target, descriptor.key, descriptor);
                }
            }

            return function (Constructor, protoProps, staticProps) {
                if (protoProps) defineProperties(Constructor.prototype, protoProps);
                if (staticProps) defineProperties(Constructor, staticProps);
                return Constructor;
            };
        }();

        var Builder = function () {
            function Builder(path) {
                _classCallCheck(this, Builder);

                this._path = path;
            }

            _createClass(Builder, [{
                key: 'mirroring',
                value: function mirroring() {
                    return this.path('mirroring', 'latest');
                }
            }, {
                key: 'panel',
                value: function panel(id) {
                    return this.path('mirrorServers', id, 'webPanels', 'config');
                }
            }, {
                key: 'path',
                value: function path() {
                    if (this._path.indexOf('?') >= 0) {
                        throw new Error('Can\'t add path components after query params!');
                    }

                    for (var _len = arguments.length, comps = Array(_len), _key = 0; _key < _len; _key++) {
                        comps[_key] = arguments[_key];
                    }

                    this._path += '/' + comps.map(encodeURIComponent).join('/');
                    return this;
                }
            }, {
                key: 'params',
                value: function params(obj) {
                    var _this = this;

                    if (this._path.indexOf('?') >= 0) {
                        throw new Error('params can only be called once. Pass all query params in the obj!');
                    }
                    if (obj) {
                        (function () {
                            var params = [];
                            Object.keys(obj).forEach(function (key) {
                                params.push(encodeURIComponent(key) + '=' + encodeURIComponent(obj[key]));
                            });
                            _this._path += params.length ? '?' + params.join('&') : '';
                        })();
                    }
                    return this;
                }
            }, {
                key: 'build',
                value: function build() {
                    return _aui2.default.contextPath() + this._path;
                }
            }]);

            return Builder;
        }();

        /**
         * Mirroring specific REST URL Builder.
         */
        var NavBuilder = {
            rest: function rest() {
                return new Builder('/rest');
            }
        };

        exports.default = NavBuilder;
        module.exports = exports['default'];
    }
);