define(
    'bitbucket/internal/bbui/inbox',
    ['module', 'exports', 'jquery', 'lodash', 'react', './aui-react/spinner', './models', './paged-table', './pull-request-table/components/author-avatar', './pull-request-table/components/comments', './pull-request-table/components/pull-request-row', './pull-request-table/components/reviewers', './pull-request-table/components/tasks', './pull-request-table/components/web-section', './utils/pull-request-unique-id', './inbox/components/summary'],
    function (module, exports, _jquery, _lodash, _react, _spinner, _models, _pagedTable, _authorAvatar, _comments, _pullRequestRow, _reviewers, _tasks, _webSection, _pullRequestUniqueId, _summary) {
        'use strict';

        Object.defineProperty(exports, "__esModule", {
            value: true
        });

        var _jquery2 = _interopRequireDefault(_jquery);

        var _lodash2 = _interopRequireDefault(_lodash);

        var _spinner2 = _interopRequireDefault(_spinner);

        var _models2 = _interopRequireDefault(_models);

        var _pagedTable2 = _interopRequireDefault(_pagedTable);

        var _authorAvatar2 = _interopRequireDefault(_authorAvatar);

        var _comments2 = _interopRequireDefault(_comments);

        var _pullRequestRow2 = _interopRequireDefault(_pullRequestRow);

        var _reviewers2 = _interopRequireDefault(_reviewers);

        var _tasks2 = _interopRequireDefault(_tasks);

        var _pullRequestUniqueId2 = _interopRequireDefault(_pullRequestUniqueId);

        var _summary2 = _interopRequireDefault(_summary);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                default: obj
            };
        }

        var _extends = Object.assign || function (target) {
            for (var i = 1; i < arguments.length; i++) {
                var source = arguments[i];

                for (var key in source) {
                    if (Object.prototype.hasOwnProperty.call(source, key)) {
                        target[key] = source[key];
                    }
                }
            }

            return target;
        };

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        }

        var _createClass = function () {
            function defineProperties(target, props) {
                for (var i = 0; i < props.length; i++) {
                    var descriptor = props[i];
                    descriptor.enumerable = descriptor.enumerable || false;
                    descriptor.configurable = true;
                    if ("value" in descriptor) descriptor.writable = true;
                    Object.defineProperty(target, descriptor.key, descriptor);
                }
            }

            return function (Constructor, protoProps, staticProps) {
                if (protoProps) defineProperties(Constructor.prototype, protoProps);
                if (staticProps) defineProperties(Constructor, staticProps);
                return Constructor;
            };
        }();

        function _possibleConstructorReturn(self, call) {
            if (!self) {
                throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
            }

            return call && (typeof call === "object" || typeof call === "function") ? call : self;
        }

        function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
            }

            subClass.prototype = Object.create(superClass && superClass.prototype, {
                constructor: {
                    value: subClass,
                    enumerable: false,
                    writable: true,
                    configurable: true
                }
            });
            if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
        }

        var Inbox = function (_Component) {
            _inherits(Inbox, _Component);

            function Inbox() {
                _classCallCheck(this, Inbox);

                return _possibleConstructorReturn(this, Object.getPrototypeOf(Inbox).apply(this, arguments));
            }

            _createClass(Inbox, [{
                key: 'componentDidMount',
                value: function componentDidMount() {
                    (0, _jquery2.default)(document).on('click', '.inbox-table-wrapper .tabs-menu a', this.changeTabs);

                    this.props.created.onMoreItemsRequested();
                    this.props.reviewing.onMoreItemsRequested();
                }
            }, {
                key: 'componentWillUnmount',
                value: function componentWillUnmount() {
                    (0, _jquery2.default)(document).off('click', '.inbox-table-wrapper .tabs-menu a', this.changeTabs);
                }
            }, {
                key: 'changeTabs',
                value: function changeTabs(event) {
                    AJS.tabs.change((0, _jquery2.default)(event.currentTarget), event);
                    event.preventDefault();
                }
            }, {
                key: 'isPrReviewed',
                value: function isPrReviewed(reviewers, currentUser) {
                    return _lodash2.default.some(reviewers, function (reviewer) {
                        return reviewer.user.name === currentUser.name && reviewer.state === _models2.default.ApprovalState.NEEDS_WORK;
                    });
                }
            }, {
                key: 'render',
                value: function render() {
                    var _this2 = this;

                    var props = this.props;
                    var emptyInbox = React.createElement(
                        'div',
                        { className: 'empty-inbox-message' },
                        React.createElement(
                            'span',
                            { className: 'aui-icon aui-icon-large aui-iconfont-workbox-empty' },
                            AJS.I18n.getText('bitbucket.component.inbox.empty.description')
                        ),
                        React.createElement(
                            'h3',
                            null,
                            AJS.I18n.getText('bitbucket.component.inbox.empty.title')
                        )
                    );

                    var reviewingContent = props.reviewing.pullRequests.length || props.reviewing.loading ? React.createElement(_pagedTable2.default, _extends({}, props.reviewing, {
                        className: 'pull-requests-table',
                        allFetchedMessage: AJS.I18n.getText('bitbucket.pull.request.all.fetched'),
                        items: props.reviewing.pullRequests,
                        onMoreItemsRequested: props.reviewing.onMoreItemsRequested,
                        scrollElement: '.inbox-table-wrapper',
                        row: function row(_ref) {
                            var item = _ref.item;
                            var focused = _ref.focused;

                            var pullRequest = item;
                            return React.createElement(
                                _pullRequestRow2.default,
                                {
                                    key: (0, _pullRequestUniqueId2.default)(pullRequest),
                                    focused: focused,
                                    prNeedsWork: _this2.isPrReviewed(pullRequest.reviewers, props.currentUser)
                                },
                                React.createElement(_authorAvatar2.default, { author: pullRequest.author }),
                                React.createElement(_summary2.default, { pullRequest: pullRequest }),
                                _webSection.beforeSections.map(function (section) {
                                    return React.createElement(_webSection.WebSectionCell, {
                                        key: section.key + '::before',
                                        where: 'before',
                                        webSection: section,
                                        pullRequest: pullRequest
                                    });
                                }),
                                React.createElement(_reviewers2.default, {
                                    currentUser: props.currentUser,
                                    currentUserAvatarSize: 'medium',
                                    dialogReviewersAsTooltip: true,
                                    pullRequest: pullRequest
                                }),
                                React.createElement(_comments2.default, { pullRequest: pullRequest }),
                                React.createElement(_tasks2.default, { pullRequest: pullRequest })
                            );
                        }
                    })) : emptyInbox;

                    var createdContent = props.created.pullRequests.length || props.created.loading ? React.createElement(_pagedTable2.default, _extends({}, props.created, {
                        className: 'pull-requests-table',
                        allFetchedMessage: AJS.I18n.getText('bitbucket.pull.request.all.fetched'),
                        items: props.created.pullRequests,
                        onMoreItemsRequested: props.created.onMoreItemsRequested,
                        scrollElement: '.inbox-table-wrapper',
                        row: function row(_ref2) {
                            var item = _ref2.item;
                            var focused = _ref2.focused;

                            var pullRequest = item;
                            return React.createElement(
                                _pullRequestRow2.default,
                                { key: (0, _pullRequestUniqueId2.default)(pullRequest), focused: focused },
                                React.createElement(_summary2.default, { pullRequest: pullRequest }),
                                _webSection.beforeSections.map(function (section) {
                                    return React.createElement(_webSection.WebSectionCell, {
                                        key: section.key + '::before',
                                        where: 'before',
                                        webSection: section,
                                        pullRequest: pullRequest
                                    });
                                }),
                                React.createElement(_reviewers2.default, {
                                    pullRequest: pullRequest,
                                    dialogReviewersAsTooltip: true
                                }),
                                React.createElement(_comments2.default, { pullRequest: pullRequest }),
                                React.createElement(_tasks2.default, { pullRequest: pullRequest })
                            );
                        }
                    })) : emptyInbox;

                    var dialogContent = !props.reviewing.pullRequests.length && !props.created.pullRequests.length && (props.reviewing.loading || props.created.loading) ? React.createElement(
                        'div',
                        { className: 'inbox-spinner-padding' },
                        React.createElement(_spinner2.default, null)
                    ) : React.createElement(
                        'div',
                        { id: 'inbox-wapper' },
                        React.createElement(
                            'h2',
                            null,
                            AJS.I18n.getText('bitbucket.component.inbox.title')
                        ),
                        React.createElement(
                            'div',
                            { className: 'inbox-table-wrapper aui-tabs horizontal-tabs' },
                            React.createElement(
                                'ul',
                                { className: 'tabs-menu' },
                                React.createElement(
                                    'li',
                                    { className: 'active-tab inbox-reviewer-tab menu-item' },
                                    React.createElement(
                                        'a',
                                        { href: '#inbox-pull-request-reviewer' },
                                        AJS.I18n.getText('bitbucket.component.inbox.reviewing')
                                    )
                                ),
                                React.createElement(
                                    'li',
                                    { className: 'inbox-created-tab menu-item' },
                                    React.createElement(
                                        'a',
                                        { href: '#inbox-pull-request-created' },
                                        AJS.I18n.getText('bitbucket.component.inbox.created')
                                    )
                                )
                            ),
                            React.createElement(
                                'div',
                                { id: 'inbox-pull-request-reviewer', className: 'tabs-pane active-pane' },
                                reviewingContent
                            ),
                            React.createElement(
                                'div',
                                { id: 'inbox-pull-request-created', className: 'tabs-pane' },
                                createdContent
                            )
                        )
                    );

                    return dialogContent;
                }
            }], [{
                key: 'propTypes',
                get: function get() {
                    return {
                        created: _react.PropTypes.shape({
                            allFetched: _react.PropTypes.bool.isRequired,
                            loading: _react.PropTypes.bool.isRequired,
                            onMoreItemsRequested: _react.PropTypes.func.isRequired,
                            pullRequests: _react.PropTypes.array.isRequired
                        }).isRequired,
                        currentUser: _react.PropTypes.object.isRequired,
                        reviewing: _react.PropTypes.shape({
                            allFetched: _react.PropTypes.bool.isRequired,
                            loading: _react.PropTypes.bool.isRequired,
                            onMoreItemsRequested: _react.PropTypes.func.isRequired,
                            pullRequests: _react.PropTypes.array.isRequired
                        }).isRequired
                    };
                }
            }]);

            return Inbox;
        }(_react.Component);

        exports.default = Inbox;
        module.exports = exports['default'];
    }
);