define(
    'bitbucket/internal/bbui/inbox/components/summary',
    ['module', 'exports', 'react', 'bitbucket/internal/impl/urls', '../../aui-react/icon'],
    function (module, exports, _react, _urls, _icon) {
        'use strict';

        Object.defineProperty(exports, "__esModule", {
            value: true
        });

        var _urls2 = _interopRequireDefault(_urls);

        var _icon2 = _interopRequireDefault(_icon);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                default: obj
            };
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        }

        var _createClass = function () {
            function defineProperties(target, props) {
                for (var i = 0; i < props.length; i++) {
                    var descriptor = props[i];
                    descriptor.enumerable = descriptor.enumerable || false;
                    descriptor.configurable = true;
                    if ("value" in descriptor) descriptor.writable = true;
                    Object.defineProperty(target, descriptor.key, descriptor);
                }
            }

            return function (Constructor, protoProps, staticProps) {
                if (protoProps) defineProperties(Constructor.prototype, protoProps);
                if (staticProps) defineProperties(Constructor, staticProps);
                return Constructor;
            };
        }();

        function _possibleConstructorReturn(self, call) {
            if (!self) {
                throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
            }

            return call && (typeof call === "object" || typeof call === "function") ? call : self;
        }

        function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
            }

            subClass.prototype = Object.create(superClass && superClass.prototype, {
                constructor: {
                    value: subClass,
                    enumerable: false,
                    writable: true,
                    configurable: true
                }
            });
            if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
        }

        var Summary = function (_Component) {
            _inherits(Summary, _Component);

            function Summary() {
                _classCallCheck(this, Summary);

                return _possibleConstructorReturn(this, Object.getPrototypeOf(Summary).apply(this, arguments));
            }

            _createClass(Summary, [{
                key: 'shouldComponentUpdate',
                value: function shouldComponentUpdate(newProps) {
                    return this.props.pullRequest.id !== newProps.pullRequest.id || this.props.pullRequest.title !== newProps.pullRequest.title || this.props.pullRequest.to_ref.id !== newProps.pullRequest.to_ref.id || this.props.pullRequest.updated_date !== newProps.pullRequest.updated_date;
                }
            }, {
                key: 'render',
                value: function render() {
                    var pullRequest = this.props.pullRequest;
                    return React.createElement(
                        'td',
                        { className: 'summary' },
                        React.createElement(
                            'div',
                            { className: 'title-and-target-branch' },
                            React.createElement(
                                'a',
                                { className: 'pull-request-title',
                                    title: pullRequest.title,
                                    href: _urls2.default.inboxPullRequest(pullRequest.to_ref.repository.project, pullRequest.to_ref.repository, pullRequest)
                                },
                                pullRequest.title
                            )
                        ),
                        React.createElement(
                            'div',
                            { className: 'pull-request-project-repo' },
                            React.createElement(
                                'span',
                                { className: 'project-name' },
                                pullRequest.to_ref.repository.project.name
                            ),
                            React.createElement(_icon2.default, { size: 'small', icon: 'collapsed' }),
                            React.createElement(
                                'span',
                                { className: 'repo-name' },
                                pullRequest.to_ref.repository.name
                            )
                        )
                    );
                }
            }], [{
                key: 'propTypes',
                get: function get() {
                    return {
                        pullRequest: _react.PropTypes.object.isRequired
                    };
                }
            }]);

            return Summary;
        }(_react.Component);

        Summary.Header = function () {
            return React.createElement(
                'th',
                { className: 'summary', scope: 'col' },
                AJS.I18n.getText('bitbucket.pull.request.table.title.summary')
            );
        };

        exports.default = Summary;
        module.exports = exports['default'];
    }
);