define(
    'bitbucket/internal/bbui/image-differ',
    ['exports', 'jquery', './image-differ/image-differ', './image-differ/image-differ-toolbar'],
    function (exports, _jquery, _imageDiffer, _imageDifferToolbar) {
        'use strict';

        Object.defineProperty(exports, "__esModule", {
            value: true
        });
        exports.Toolbar = exports.Differ = exports.init = undefined;

        var _jquery2 = _interopRequireDefault(_jquery);

        var _imageDiffer2 = _interopRequireDefault(_imageDiffer);

        var _imageDifferToolbar2 = _interopRequireDefault(_imageDifferToolbar);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                default: obj
            };
        }

        /**
         * @param {jQuery|HtmlElement} container - The container to use for this Image Differ
         * @returns {{on: Function, readyPromise: Promise}}
         */
        function init(container) {
            var $container = (0, _jquery2.default)(container);
            var toolbar = new _imageDifferToolbar2.default((0, _jquery2.default)(bitbucket.internal.component.imageDiffer.toolbar.main()).prependTo($container));
            var differ = new _imageDiffer2.default($container);

            toolbar.on('modeChanged', function (mode) {
                return differ.setMode(mode.newMode);
            });

            var readyPromise = new _jquery2.default.Deferred();
            differ.init().done(function (enabledModes) {
                if (toolbar) {
                    toolbar.init(enabledModes);
                }
                readyPromise.resolve({

                    /**
                     * Stop exposing this method when Stash no longer needs to retrigger Image Differ events
                     * @deprecated
                     */
                    on: differ.on.bind(differ),
                    enabledModes: enabledModes,
                    _differ: differ,
                    _toolbar: toolbar,
                    destroy: function destroy() {
                        differ.destroy();
                        differ = null;
                        toolbar.destroy();
                        toolbar = null;
                    }
                });
            });
            return readyPromise;
        }

        exports.init = init;
        exports.Differ = _imageDiffer2.default;
        exports.Toolbar = _imageDifferToolbar2.default;
    }
);