define(
  'bitbucket/internal/bbui/data-provider/pull-request-list',
  ['module', 'exports', 'bitbucket/internal/impl/data-provider/paged', './../json-validation', './../models'],
  function (module, exports, _paged, _jsonValidation, _models) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
      value: true
    });

    var _paged2 = _interopRequireDefault(_paged);

    var _jsonValidation2 = _interopRequireDefault(_jsonValidation);

    var _models2 = _interopRequireDefault(_models);

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }

    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }

    function _possibleConstructorReturn(self, call) {
      if (!self) {
        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
      }

      return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
      if (typeof superClass !== "function" && superClass !== null) {
        throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
      }

      subClass.prototype = Object.create(superClass && superClass.prototype, {
        constructor: {
          value: subClass,
          enumerable: false,
          writable: true,
          configurable: true
        }
      });
      if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var PullRequestListDataProvider = function (_PagedDataProvider) {
      _inherits(PullRequestListDataProvider, _PagedDataProvider);

      function PullRequestListDataProvider() {
        var _Object$getPrototypeO;

        var options = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

        _classCallCheck(this, PullRequestListDataProvider);

        /**
         * We extend the pull_request model with commentCount and taskCount
         */
        options.jsonDescriptor = [_models2.default.pull_request];

        /**
         * @type {Object}
         * @property {string?} author_id - the author's username
         * @property {string?} target_ref_id - the ref string, e.g. refs/heads/
         * @property {string?} reviewer_id - the reviewer's username
         * @property {string?} query - title / description substring search
         * @property {models.PullRequestState?} state
         */
        options.filterDescriptor = {
          author_id: 'string?',
          query: 'string?',
          target_ref_id: 'string?',
          reviewer_id: 'string?',
          state: _jsonValidation2.default.asEnum('PullRequestState', _models2.default.PullRequestState)
        };

        for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
          args[_key - 1] = arguments[_key];
        }

        return _possibleConstructorReturn(this, (_Object$getPrototypeO = Object.getPrototypeOf(PullRequestListDataProvider)).call.apply(_Object$getPrototypeO, [this, options].concat(args)));
      }

      return PullRequestListDataProvider;
    }(_paged2.default);

    exports.default = PullRequestListDataProvider;
    module.exports = exports['default'];
  }
);