define(
    'bitbucket/internal/bbui/self-reviewer',
    ['module', 'exports', 'aui', 'classnames', 'react', './aui-react/inline-dialog', './models', './reviewer-avatar', './tipsy'],
    function (module, exports, _aui, _classnames, _react, _inlineDialog, _models, _reviewerAvatar, _tipsy) {
        'use strict';

        Object.defineProperty(exports, "__esModule", {
            value: true
        });

        var _aui2 = _interopRequireDefault(_aui);

        var _classnames2 = _interopRequireDefault(_classnames);

        var _inlineDialog2 = _interopRequireDefault(_inlineDialog);

        var _reviewerAvatar2 = _interopRequireDefault(_reviewerAvatar);

        var _tipsy2 = _interopRequireDefault(_tipsy);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                default: obj
            };
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        }

        var _createClass = function () {
            function defineProperties(target, props) {
                for (var i = 0; i < props.length; i++) {
                    var descriptor = props[i];
                    descriptor.enumerable = descriptor.enumerable || false;
                    descriptor.configurable = true;
                    if ("value" in descriptor) descriptor.writable = true;
                    Object.defineProperty(target, descriptor.key, descriptor);
                }
            }

            return function (Constructor, protoProps, staticProps) {
                if (protoProps) defineProperties(Constructor.prototype, protoProps);
                if (staticProps) defineProperties(Constructor, staticProps);
                return Constructor;
            };
        }();

        function _possibleConstructorReturn(self, call) {
            if (!self) {
                throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
            }

            return call && (typeof call === "object" || typeof call === "function") ? call : self;
        }

        function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
            }

            subClass.prototype = Object.create(superClass && superClass.prototype, {
                constructor: {
                    value: subClass,
                    enumerable: false,
                    writable: true,
                    configurable: true
                }
            });
            if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
        }

        var propTypes = {
            currentUserAsReviewer: _react.PropTypes.object,
            isWatching: _react.PropTypes.bool,
            onSelfClick: _react.PropTypes.func.isRequired,
            removeSelfModalId: _react.PropTypes.string.isRequired
        };

        var SelfReviewer = function (_Component) {
            _inherits(SelfReviewer, _Component);

            function SelfReviewer() {
                _classCallCheck(this, SelfReviewer);

                var _this = _possibleConstructorReturn(this, Object.getPrototypeOf(SelfReviewer).call(this));

                // hover state is managed by js because chrome
                // does not fire mouse events on elements that
                // have a parent that is animating
                _this.state = { hovered: false };
                return _this;
            }

            _createClass(SelfReviewer, [{
                key: 'mouseEnter',
                value: function mouseEnter(e) {
                    this.setState({ hovered: true });
                }
            }, {
                key: 'mouseLeave',
                value: function mouseLeave(e) {
                    this.setState({ hovered: false });
                }
            }, {
                key: 'createUnwatchMarkup',
                value: function createUnwatchMarkup() {
                    return { __html: _aui2.default.I18n.getText('bitbucket.component.self.reviewer.unwatch.html') };
                }
            }, {
                key: 'render',
                value: function render() {
                    var _this2 = this;

                    var initTipsyDelay = 500; // delay 'remove yourself' tipsy so it doesn't appear during animation
                    var currentUserAsReviewer = this.props.currentUserAsReviewer;
                    var unWatchCheckbox = React.createElement(
                        'p',
                        null,
                        React.createElement(
                            'label',
                            null,
                            React.createElement('input', {
                                className: 'checkbox',
                                type: 'checkbox',
                                ref: function ref(el) {
                                    _this2._unwatchCheckbox = el;
                                }
                            }),
                            React.createElement('span', { dangerouslySetInnerHTML: this.createUnwatchMarkup() })
                        )
                    );

                    if (!currentUserAsReviewer) {
                        return React.createElement(
                            'div',
                            { className: 'self-avatar' },
                            React.createElement(
                                _tipsy2.default,
                                {
                                    key: 'add-self',
                                    ref: function ref(el) {
                                        _this2._add_self = el;
                                    },
                                    title: _aui2.default.I18n.getText('bitbucket.component.self.reviewer.add'),
                                    className: 'add-self'
                                },
                                React.createElement(
                                    'button',
                                    {
                                        onClick: function onClick() {
                                            _this2.setState({ hovered: false });
                                            _this2.props.onSelfClick(_models.SelfAction.ADD_SELF);
                                        },
                                        className: 'aui-button'
                                    },
                                    '+'
                                )
                            )
                        );
                    }

                    return React.createElement(
                        'div',
                        {
                            className: (0, _classnames2.default)('self-avatar', { jsHover: this.state.hovered, reviewing: this.props.currentUserAsReviewer }),
                            onMouseEnter: function onMouseEnter() {
                                return _this2.mouseEnter();
                            },
                            onMouseLeave: function onMouseLeave() {
                                return _this2.mouseLeave();
                            }
                        },
                        React.createElement(
                            _tipsy2.default,
                            {
                                key: 'remove-self',
                                title: _aui2.default.I18n.getText('bitbucket.component.self.reviewer.remove'),
                                className: 'remove-self',
                                delay: initTipsyDelay
                            },
                            React.createElement(
                                _inlineDialog.InlineDialogTrigger,
                                {
                                    dialogId: this.props.removeSelfModalId,
                                    className: 'aui-button'
                                },
                                '–'
                            )
                        ),
                        React.createElement(
                            _inlineDialog2.default,
                            {
                                key: 'remove_self_dialog',
                                id: this.props.removeSelfModalId,
                                className: 'remove-self-dialog',
                                alignment: 'bottom right'
                            },
                            React.createElement(
                                'h5',
                                null,
                                _aui2.default.I18n.getText('bitbucket.component.self.reviewer.remove.confirm.header')
                            ),
                            React.createElement(
                                'p',
                                null,
                                _aui2.default.I18n.getText('bitbucket.component.self.reviewer.remove.confirm')
                            ),
                            this.props.isWatching ? unWatchCheckbox : null,
                            React.createElement(
                                'p',
                                null,
                                React.createElement(
                                    'button',
                                    {
                                        className: 'aui-button',
                                        onClick: function onClick(e) {
                                            return _this2.props.onSelfClick(_models.SelfAction.REMOVE_SELF, _this2._unwatchCheckbox ? _this2._unwatchCheckbox.checked : null);
                                        }
                                    },
                                    _aui2.default.I18n.getText('bitbucket.component.self.reviewer.remove.confirm.button')
                                )
                            )
                        ),
                        React.createElement(_reviewerAvatar2.default, { reviewer: currentUserAsReviewer, tooltip: false }),
                        ';'
                    );
                }
            }]);

            return SelfReviewer;
        }(_react.Component);

        SelfReviewer.propTypes = propTypes;

        exports.default = SelfReviewer;
        module.exports = exports['default'];
    }
);