define(
    'bitbucket/internal/bbui/pull-request-table/legacy',
    ['module', 'exports', 'aui', 'jquery', 'lodash', '../avatars', '../paged-table/legacy', 'bitbucket/internal/impl/urls', 'bitbucket/internal/impl/web-fragments', '../avatar-list', '../ref-label', '../time'],
    function (module, exports, _aui, _jquery, _lodash, _avatars, _legacy) {
        'use strict';

        Object.defineProperty(exports, "__esModule", {
            value: true
        });

        var _aui2 = _interopRequireDefault(_aui);

        var _jquery2 = _interopRequireDefault(_jquery);

        var _lodash2 = _interopRequireDefault(_lodash);

        var _avatars2 = _interopRequireDefault(_avatars);

        var _legacy2 = _interopRequireDefault(_legacy);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                default: obj
            };
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        }

        var _createClass = function () {
            function defineProperties(target, props) {
                for (var i = 0; i < props.length; i++) {
                    var descriptor = props[i];
                    descriptor.enumerable = descriptor.enumerable || false;
                    descriptor.configurable = true;
                    if ("value" in descriptor) descriptor.writable = true;
                    Object.defineProperty(target, descriptor.key, descriptor);
                }
            }

            return function (Constructor, protoProps, staticProps) {
                if (protoProps) defineProperties(Constructor.prototype, protoProps);
                if (staticProps) defineProperties(Constructor, staticProps);
                return Constructor;
            };
        }();

        function _possibleConstructorReturn(self, call) {
            if (!self) {
                throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
            }

            return call && (typeof call === "object" || typeof call === "function") ? call : self;
        }

        var _get = function get(object, property, receiver) {
            if (object === null) object = Function.prototype;
            var desc = Object.getOwnPropertyDescriptor(object, property);

            if (desc === undefined) {
                var parent = Object.getPrototypeOf(object);

                if (parent === null) {
                    return undefined;
                } else {
                    return get(parent, property, receiver);
                }
            } else if ("value" in desc) {
                return desc.value;
            } else {
                var getter = desc.get;

                if (getter === undefined) {
                    return undefined;
                }

                return getter.call(receiver);
            }
        };

        function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
            }

            subClass.prototype = Object.create(superClass && superClass.prototype, {
                constructor: {
                    value: subClass,
                    enumerable: false,
                    writable: true,
                    configurable: true
                }
            });
            if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
        }

        // for soy

        var customMapping = {
            aMomentAgo: function aMomentAgo() {
                return _aui2.default.I18n.getText('bitbucket.pull.request.updated.date.format.a.moment.ago');
            },
            oneMinuteAgo: function oneMinuteAgo() {
                return _aui2.default.I18n.getText('bitbucket.pull.request.updated.date.format.one.minute.ago');
            },
            xMinutesAgo: function xMinutesAgo(param) {
                return _aui2.default.I18n.getText('bitbucket.pull.request.updated.date.format.x.minutes.ago', param);
            },
            oneHourAgo: function oneHourAgo() {
                return _aui2.default.I18n.getText('bitbucket.pull.request.updated.date.format.one.hour.ago');
            },
            xHoursAgo: function xHoursAgo(param) {
                return _aui2.default.I18n.getText('bitbucket.pull.request.updated.date.format.x.hours.ago', param);
            },
            oneDayAgo: function oneDayAgo() {
                return _aui2.default.I18n.getText('bitbucket.pull.request.updated.date.format.one.day.ago');
            },
            xDaysAgo: function xDaysAgo(param) {
                return _aui2.default.I18n.getText('bitbucket.pull.request.updated.date.format.x.days.ago', param);
            },
            oneWeekAgo: function oneWeekAgo() {
                return _aui2.default.I18n.getText('bitbucket.pull.request.updated.date.format.one.week.ago');
            },
            defaultType: function defaultType(param) {
                return _aui2.default.I18n.getText('bitbucket.pull.request.updated.date.format.absolute', param);
            }
        };

        var PullRequestTable = function (_PagedTable) {
            _inherits(PullRequestTable, _PagedTable);

            /**
             * @param {jQuery|HTMLElement} el - the element to render the pull request table in to.
             * @param {Object} options - Options for this PullRequestTable
             * @param {jQuery|HTMLElement} options.tableEl - The table element to use as a container for this PullRequestTable
             * @param {Repository} options.repository - The repository this PullRequestTable is displayed in
             * @param {User?} options.currentUser - The current user
             */

            function PullRequestTable(el) {
                var options = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

                _classCallCheck(this, PullRequestTable);

                options = _jquery2.default.extend({
                    tableEl: (0, _jquery2.default)(bitbucket.internal.component.pullRequestTable.main({
                        id: 'bitbucket-pull-request-table',
                        currentUser: JSON.stringify(options.currentUser)
                    }))
                }, options);

                (0, _jquery2.default)(el).append(options.tableEl);

                var _this = _possibleConstructorReturn(this, Object.getPrototypeOf(PullRequestTable).call(this, options));

                _this._ids = _this._ids || {};

                _this.$tbody = _this.$table.find('tbody');

                _avatars2.default.init();
                return _this;
            }

            _createClass(PullRequestTable, [{
                key: 'clear',
                value: function clear() {
                    _get(Object.getPrototypeOf(PullRequestTable.prototype), 'clear', this).call(this);
                    this._ids = {};
                }
            }, {
                key: 'handleNewRows',
                value: function handleNewRows(data) {
                    var rowsHtml = data.map(function (pullRequest) {
                        return bitbucket.internal.component.pullRequestTable.row({
                            customMapping: customMapping,
                            pullRequest: pullRequest
                        });
                    });

                    this.$tbody.append(rowsHtml.join(''));
                }
            }, {
                key: 'handleErrors',
                value: function handleErrors(errors) {
                    console.error(errors);
                }
            }, {
                key: 'idForEntity',
                value: function idForEntity(pr) {
                    return pr.id;
                }
            }, {
                key: '_moveFocus',
                value: function _moveFocus() {
                    var _get2;

                    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                        args[_key] = arguments[_key];
                    }

                    (_get2 = _get(Object.getPrototypeOf(PullRequestTable.prototype), '_moveFocus', this)).call.apply(_get2, [this].concat(args));
                    // set browser focus on the PR title link
                    this._getFocusedItem().find(this.options.focusOptions.itemLinkSelector).focus();
                }
            }]);

            return PullRequestTable;
        }(_legacy2.default);

        // We do a merge here so that we get all of the paged table defaults for focusOptions as well.
        PullRequestTable.defaults = _lodash2.default.merge({}, _legacy2.default.defaults, {
            autoLoad: true,
            allFetchedMessageHtml: bitbucket.internal.component.pullRequestTable.allFetched()
        });

        exports.default = PullRequestTable;
        module.exports = exports['default'];
    }
);