define(
    'bitbucket/internal/bbui/pull-request-table/components/web-section',
    ['exports', 'react', 'bitbucket/internal/impl/web-fragments', '../../utils/pull-request-unique-id'],
    function (exports, _react, _webFragments, _pullRequestUniqueId) {
        'use strict';

        Object.defineProperty(exports, "__esModule", {
            value: true
        });
        exports.WebSectionCell = exports.WebSectionHeader = exports.afterSections = exports.beforeSections = undefined;

        var _react2 = _interopRequireDefault(_react);

        var _webFragments2 = _interopRequireDefault(_webFragments);

        var _pullRequestUniqueId2 = _interopRequireDefault(_pullRequestUniqueId);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                default: obj
            };
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        }

        var _createClass = function () {
            function defineProperties(target, props) {
                for (var i = 0; i < props.length; i++) {
                    var descriptor = props[i];
                    descriptor.enumerable = descriptor.enumerable || false;
                    descriptor.configurable = true;
                    if ("value" in descriptor) descriptor.writable = true;
                    Object.defineProperty(target, descriptor.key, descriptor);
                }
            }

            return function (Constructor, protoProps, staticProps) {
                if (protoProps) defineProperties(Constructor.prototype, protoProps);
                if (staticProps) defineProperties(Constructor, staticProps);
                return Constructor;
            };
        }();

        function _possibleConstructorReturn(self, call) {
            if (!self) {
                throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
            }

            return call && (typeof call === "object" || typeof call === "function") ? call : self;
        }

        function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
            }

            subClass.prototype = Object.create(superClass && superClass.prototype, {
                constructor: {
                    value: subClass,
                    enumerable: false,
                    writable: true,
                    configurable: true
                }
            });
            if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
        }

        var beforeSections = exports.beforeSections = _webFragments2.default.getWebSections('bitbucket.pull-request.table-column.before');
        var afterSections = exports.afterSections = _webFragments2.default.getWebSections('bitbucket.pull-request.table-column.after');

        var WebSectionHeader = exports.WebSectionHeader = function WebSectionHeader(props) {
            var webSection = props.webSection;
            return _react2.default.createElement(
                'th',
                {
                    className: webSection.key + " web-section-column",
                    title: webSection.text,
                    scope: 'col'
                },
                webSection.text
            );
        };

        WebSectionHeader.propTypes = {
            webSection: _react.PropTypes.object.isRequired
        };

        var WebSectionCell = exports.WebSectionCell = function (_Component) {
            _inherits(WebSectionCell, _Component);

            function WebSectionCell() {
                _classCallCheck(this, WebSectionCell);

                return _possibleConstructorReturn(this, Object.getPrototypeOf(WebSectionCell).apply(this, arguments));
            }

            _createClass(WebSectionCell, [{
                key: 'shouldComponentUpdate',

                // We don't want to regrab the web panels for existing rows every time the table rerenders as this would cause them to needlessly
                // redo their work. So we only regrab them when the props actually change. This component is used with a React key={} prop,
                // and in theory each row should only render once ever.
                value: function shouldComponentUpdate(newProps) {
                    return (0, _pullRequestUniqueId2.default)(newProps.pullRequest) !== (0, _pullRequestUniqueId2.default)(this.props.pullRequest) || newProps.webSection.key !== this.props.webSection.key || newProps.where !== this.props.where;
                }
            }, {
                key: 'render',
                value: function render() {
                    var webSection = this.props.webSection;
                    var pullRequest = this.props.pullRequest;
                    var location = 'bitbucket.pull-request.table-column.' + this.props.where + '/' + webSection.key;
                    return _react2.default.createElement('td', {
                        className: webSection.key + "-value web-section-column",
                        dangerouslySetInnerHTML: {
                            __html: _webFragments2.default.getWebPanels(location, { pullRequest: pullRequest }).map(function (p) {
                                return p.html;
                            }).join('')
                        }
                    });
                }
            }]);

            return WebSectionCell;
        }(_react.Component);

        WebSectionCell.propTypes = {
            pullRequest: _react.PropTypes.object.isRequired,
            webSection: _react.PropTypes.object.isRequired,
            where: _react.PropTypes.string.isRequired
        };

        exports.default = {
            afterSections: afterSections,
            beforeSections: beforeSections,
            WebSectionHeader: WebSectionHeader,
            WebSectionCell: WebSectionCell
        };
    }
);