define(
    'bitbucket/internal/bbui/pull-request-table/components/count-cell',
    ['module', 'exports', 'classnames', 'react'],
    function (module, exports, _classnames, _react) {
        'use strict';

        Object.defineProperty(exports, "__esModule", {
            value: true
        });

        var _classnames2 = _interopRequireDefault(_classnames);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                default: obj
            };
        }

        var UNCAPPED_MAX = 99;

        function cappedInt(n) {
            return n > UNCAPPED_MAX ? UNCAPPED_MAX + '+' : n + '';
        }

        var propTypes = {
            count: _react.PropTypes.number.isRequired,
            icon: _react.PropTypes.node.isRequired,
            tooltip: _react.PropTypes.string.isRequired,
            className: _react.PropTypes.string
        };

        var CountCell = function CountCell(props) {
            return React.createElement(
                'td',
                { className: (0, _classnames2.default)('count-column-value', props.className) },
                props.count > 0 && React.createElement(
                    'span',
                    { title: props.tooltip },
                    props.icon,
                    React.createElement(
                        'span',
                        null,
                        ' '
                    ),
                    React.createElement(
                        'span',
                        { className: 'count' },
                        cappedInt(props.count)
                    )
                )
            );
        };

        CountCell.Header = function () {
            return React.createElement('th', { className: 'count-column' });
        };

        CountCell.propTypes = propTypes;

        exports.default = CountCell;
        module.exports = exports['default'];
    }
);