define(
    'bitbucket/internal/bbui/pull-request-list/legacy',
    ['module', 'exports', 'aui', 'jquery', 'lodash', 'bitbucket/internal/impl/data-provider/participants', 'bitbucket/internal/impl/data-provider/pull-request-list', 'bitbucket/internal/impl/data-provider/ref', '../filter-bar/legacy', '../models', '../pull-request-table/legacy', '../widget', './dom-event', 'bitbucket/internal/impl/urls'],
    function (module, exports, _aui, _jquery, _lodash, _participants, _pullRequestList, _ref, _legacy, _models, _legacy3, _widget, _domEvent) {
        'use strict';

        Object.defineProperty(exports, "__esModule", {
            value: true
        });

        var _aui2 = _interopRequireDefault(_aui);

        var _jquery2 = _interopRequireDefault(_jquery);

        var _lodash2 = _interopRequireDefault(_lodash);

        var _participants2 = _interopRequireDefault(_participants);

        var _pullRequestList2 = _interopRequireDefault(_pullRequestList);

        var _ref2 = _interopRequireDefault(_ref);

        var _legacy2 = _interopRequireDefault(_legacy);

        var _models2 = _interopRequireDefault(_models);

        var _legacy4 = _interopRequireDefault(_legacy3);

        var _widget2 = _interopRequireDefault(_widget);

        var _domEvent2 = _interopRequireDefault(_domEvent);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                default: obj
            };
        }

        var _get = function get(object, property, receiver) {
            if (object === null) object = Function.prototype;
            var desc = Object.getOwnPropertyDescriptor(object, property);

            if (desc === undefined) {
                var parent = Object.getPrototypeOf(object);

                if (parent === null) {
                    return undefined;
                } else {
                    return get(parent, property, receiver);
                }
            } else if ("value" in desc) {
                return desc.value;
            } else {
                var getter = desc.get;

                if (getter === undefined) {
                    return undefined;
                }

                return getter.call(receiver);
            }
        };

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        }

        var _createClass = function () {
            function defineProperties(target, props) {
                for (var i = 0; i < props.length; i++) {
                    var descriptor = props[i];
                    descriptor.enumerable = descriptor.enumerable || false;
                    descriptor.configurable = true;
                    if ("value" in descriptor) descriptor.writable = true;
                    Object.defineProperty(target, descriptor.key, descriptor);
                }
            }

            return function (Constructor, protoProps, staticProps) {
                if (protoProps) defineProperties(Constructor.prototype, protoProps);
                if (staticProps) defineProperties(Constructor, staticProps);
                return Constructor;
            };
        }();

        function _possibleConstructorReturn(self, call) {
            if (!self) {
                throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
            }

            return call && (typeof call === "object" || typeof call === "function") ? call : self;
        }

        function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
            }

            subClass.prototype = Object.create(superClass && superClass.prototype, {
                constructor: {
                    value: subClass,
                    enumerable: false,
                    writable: true,
                    configurable: true
                }
            });
            if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
        }

        var PullRequestList = function (_Widget) {
            _inherits(PullRequestList, _Widget);

            /**
             * @param {jQuery|HTMLElement} el - The container for this PullRequestList
             * @param {Object} options - The options for this PullRequestList
             * @param {Repository?} options.repository - The current repository
             * @param {User?} options.currentUser - The current user
             * @param {Array<PullRequest>?} options.initialData - if you'd like to pass in a prefetched page of PRs, this is it.
             * @param {Object?} options.filter - The filter configuration
             * @param {boolean} options.filter.reviewer_self - true to filter to just ones where the current user is a reviewer.
             * @param {Object?} options.authorFilter - The filter to pass to the author participants data provider
             * @param {models.PullRequestState?} options.filter.state - Filter by pull request state
             * @param {Ref?} options.selectedTargetBranch - The selected branch
             * @param {Participant?} options.selectedAuthor - The selected author
             * @param {boolean} options.gettingStarted - true to show the getting started page
             * @param {{debounce: number, text:string, id: string, value: string, searchPlaceholder: string}?} options.query - describes a freetext filter
             */

            function PullRequestList(el, options) {
                _classCallCheck(this, PullRequestList);

                var _this = _possibleConstructorReturn(this, Object.getPrototypeOf(PullRequestList).call(this, options));

                options.filter = options.filter || {};
                options.filter.author_id = options.selectedAuthor && options.selectedAuthor.name;
                options.filter.target_ref_id = options.selectedTargetBranch && options.selectedTargetBranch.id;

                // we probably should make this reusable, but since this is the only place that needs it, I've punted on doing that for now.
                // The next person who want sto do preloading should extract this into something shareable (e.g., perhaps some kind of mixin
                // instead of inheriting from the user-specific provider)

                var PreloadingParticipantsDataProvider = function (_ParticipantsDataProv) {
                    _inherits(PreloadingParticipantsDataProvider, _ParticipantsDataProv);

                    function PreloadingParticipantsDataProvider(dataProviderOptions) {
                        var _Object$getPrototypeO;

                        _classCallCheck(this, PreloadingParticipantsDataProvider);

                        for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
                            args[_key - 1] = arguments[_key];
                        }

                        var _this2 = _possibleConstructorReturn(this, (_Object$getPrototypeO = Object.getPrototypeOf(PreloadingParticipantsDataProvider)).call.apply(_Object$getPrototypeO, [this, dataProviderOptions].concat(args)));

                        _this2._preloadItems = dataProviderOptions.preload || [];
                        _this2._preloaded = _this2._initialPreloadedState = _this2._preloadItems.length === 0;
                        _this2._equalityCheck = dataProviderOptions.equals || function (a, b) {
                            return a.id === b.id;
                        };
                        return _this2;
                    }

                    _createClass(PreloadingParticipantsDataProvider, [{
                        key: 'reset',
                        value: function reset() {
                            this._preloaded = this._initialPreloadedState;
                            return _get(Object.getPrototypeOf(PreloadingParticipantsDataProvider.prototype), 'reset', this).call(this);
                        }
                    }, {
                        key: '_fetchNext',
                        value: function _fetchNext(lastResponseData) {
                            if (!this._preloaded) {
                                if (this.filter.term) {
                                    this._preloaded = true;
                                } else {
                                    var promise = _jquery2.default.Deferred().resolve(this._preloadItems);
                                    promise.abort = _jquery2.default.noop;
                                    return promise;
                                }
                            }

                            return _get(Object.getPrototypeOf(PreloadingParticipantsDataProvider.prototype), '_fetchNext', this).call(this, lastResponseData === this._preloadItems ? null : lastResponseData);
                        }
                    }, {
                        key: '_transform',
                        value: function _transform(data) {
                            if (!this._preloaded) {
                                this._preloaded = true;
                                return this._preloadItems;
                            }

                            var equals = this._equalityCheck;
                            var preloadItems = this._preloadItems;
                            var out = _get(Object.getPrototypeOf(PreloadingParticipantsDataProvider.prototype), '_transform', this).call(this, data);
                            if (this.filter.term) {
                                return out;
                            }
                            // if we're not filtering, exclude the preloaded items from the output
                            return out.filter(function (item) {
                                return !preloadItems.some(function (preloadItem) {
                                    return equals(preloadItem, item);
                                });
                            });
                        }
                    }]);

                    return PreloadingParticipantsDataProvider;
                }(_participants2.default);

                var authorProvider = new PreloadingParticipantsDataProvider({
                    preload: options.currentUser ? [options.currentUser] : null,
                    equals: function equals(a, b) {
                        return a.name === b.name;
                    },
                    repository: options.repository,
                    filter: options.authorFilter || {}
                });

                var branchProvider = new _ref2.default({
                    filter: {
                        repository: options.repository,
                        type: 'branch'
                    }
                });

                var prProvider = new _pullRequestList2.default({
                    repository: options.repository.id,
                    filter: {
                        state: options.filter.state || _models2.default.PullRequestState.OPEN,
                        author_id: options.filter.author_id || null,
                        target_ref_id: options.filter.target_ref_id || null,
                        reviewer_id: options.filter.reviewer_self && options.currentUser ? options.currentUser.name : null,
                        query: options.filter.query || null
                    }
                }, options.initialData);

                if (!options.gettingStarted) {
                    (function () {
                        var pullRequestListFilters = [{
                            id: 'pr-state-filter',
                            type: _legacy2.default.Types.SELECT,
                            text: _aui2.default.I18n.getText('bitbucket.component.pull.request.list.state'),
                            value: options.filter.state,
                            menu: {
                                items: [{
                                    id: _models2.default.PullRequestState.OPEN,
                                    text: _aui2.default.I18n.getText('bitbucket.component.pull.request.list.state.open')
                                }, {
                                    id: _models2.default.PullRequestState.MERGED,
                                    text: _aui2.default.I18n.getText('bitbucket.component.pull.request.list.state.merged')
                                }, {
                                    id: _models2.default.PullRequestState.DECLINED,
                                    text: _aui2.default.I18n.getText('bitbucket.component.pull.request.list.state.declined')
                                }]
                            }
                        }, {
                            type: _legacy2.default.Types.SELECT,
                            text: _aui2.default.I18n.getText('bitbucket.component.pull.request.list.author'),
                            id: 'pr-author-filter',
                            value: options.filter.author_id || null,
                            searchPlaceholder: _aui2.default.I18n.getText('bitbucket.component.pull.request.list.search.author'),
                            menu: {
                                dataProvider: authorProvider,
                                id: function id(user) {
                                    return user.name;
                                },
                                initSelection: function initSelection($el, callback) {
                                    var username = $el.val();
                                    if (options.filter.author_id === username) {
                                        return callback(options.selectedAuthor);
                                    }
                                    throw new Error('Unexpected value \'' + username + '\' when initializing the author filter.');
                                },
                                formatSelection: function formatSelection(author) {
                                    return bitbucket.internal.component.pullRequestList.authorSelection({ author: author });
                                },
                                formatResult: function formatResult(author) {
                                    return bitbucket.internal.component.pullRequestList.authorResult({ author: author });
                                },
                                formatNoMatches: function formatNoMatches() {
                                    return _aui2.default.I18n.getText('bitbucket.component.pull.request.list.search.author.nomatches');
                                },
                                placeholder: _aui2.default.I18n.getText('bitbucket.component.pull.request.list.author'),
                                dropdownCssClass: 'pr-author-dropdown'
                            }
                        }, {
                            type: _legacy2.default.Types.SELECT,
                            text: _aui2.default.I18n.getText('bitbucket.component.pull.request.list.branch.target'),
                            id: 'pr-target-branch-filter',
                            value: options.filter.target_ref_id || null,
                            searchPlaceholder: _aui2.default.I18n.getText('bitbucket.component.pull.request.list.search.branch'),
                            menu: {
                                dataProvider: branchProvider,
                                initSelection: function initSelection($el, callback) {
                                    var branch = $el.val();
                                    if (options.filter.target_ref_id === branch) {
                                        return callback(options.selectedTargetBranch);
                                    }
                                    throw new Error('Unexpected value \'' + branch + '\' when initializing the target branch filter.');
                                },
                                formatSelection: function formatSelection(branch) {
                                    return bitbucket.internal.component.pullRequestList.targetBranchSelection({ branch: branch });
                                },
                                formatResult: function formatResult(branch) {
                                    return bitbucket.internal.component.pullRequestList.targetBranchResult({ branch: branch });
                                },
                                formatNoMatches: function formatNoMatches() {
                                    return _aui2.default.I18n.getText('bitbucket.component.pull.request.list.search.branch.nomatches');
                                },
                                placeholder: _aui2.default.I18n.getText('bitbucket.component.pull.request.list.branch.target'),
                                dropdownCssClass: 'pr-target-branch-dropdown'
                            }
                        }];

                        if (options.currentUser) {
                            // anonymous users shouldn't see the "I'm reviewing"
                            pullRequestListFilters.push({
                                type: _legacy2.default.Types.TOGGLE,
                                text: _aui2.default.I18n.getText('bitbucket.component.pull.request.list.reviewer.self'),
                                id: 'pr-reviewer-self-filter',
                                value: options.filter.reviewer_self
                            });
                        }

                        var query = options.query ? {
                            debounce: options.query.debounce,
                            id: 'pr-query-filter',
                            value: options.filter.query || null
                        } : null;

                        var filterBar = new _legacy2.default(el, {
                            id: 'pull-requests-filter-bar',
                            filters: pullRequestListFilters,
                            query: query
                        });

                        filterBar.on('change', function () {
                            var filterState = filterBar.state;
                            var cleanState = {
                                state: filterState['pr-state-filter'],
                                author_id: filterState['pr-author-filter'] || null,
                                target_ref_id: filterState['pr-target-branch-filter'] || null,
                                reviewer_self: filterState['pr-reviewer-self-filter'],
                                query: filterState['pr-query-filter'] || null
                            };

                            prProvider.setFilter('state', cleanState.state);
                            prProvider.setFilter('author_id', cleanState.author_id);
                            prProvider.setFilter('target_ref_id', cleanState.target_ref_id);
                            prProvider.setFilter('reviewer_id', cleanState.reviewer_self && options.currentUser ? options.currentUser.name : null);
                            prProvider.setFilter('query', cleanState.query);
                            prProvider.reset();

                            _this.trigger('state-change', cleanState);
                        });

                        var resetFilters = function resetFilters() {
                            filterBar.state = _lodash2.default.transform(pullRequestListFilters, function (state, filter) {
                                state[filter.id] = filter.menu && filter.menu.items ? filter.menu.items[0].id : false;
                            }, {});
                        };

                        (0, _jquery2.default)(el).on('click', '#reset-filters', function (e) {
                            if ((0, _domEvent2.default)(e)) {
                                e.preventDefault();
                                resetFilters();
                            }
                        });
                    })();
                }

                var getEmptyStateMessage = function getEmptyStateMessage() {
                    var filter = prProvider.filter;
                    var gettingStarted = options.gettingStarted;
                    var isFiltered = filter.state !== 'OPEN' || filter.author_id || filter.target_ref_id || filter.reviewer_id || filter.query;

                    if (gettingStarted) {
                        return bitbucket.internal.component.pullRequestList.gettingStarted({ repository: options.repository });
                    }
                    return isFiltered ? bitbucket.internal.component.pullRequestList.noResultsFiltered({ repository: options.repository }) : bitbucket.internal.component.pullRequestList.noResults({ repository: options.repository });
                };

                _this.pullRequestTable = new _legacy4.default(el, {
                    id: 'pull-requests-table',
                    dataProvider: prProvider,
                    getNoneFoundMessageHtml: getEmptyStateMessage,
                    repository: options.repository,
                    currentUser: options.currentUser
                });

                _this.pullRequestTable.init();

                // if there isn't a focused row set focus to the initial row in the table.
                var focusInitialRowIfNeeded = function focusInitialRowIfNeeded() {
                    if (!_this.pullRequestTable._getFocusedItem().length) {
                        _this.pullRequestTable.focusInitialRow();
                    }
                };
                // when a page is rendered, check if we need to focus the initial row.
                _this.pullRequestTable.on('page-rendered', focusInitialRowIfNeeded);
                focusInitialRowIfNeeded();
                return _this;
            }

            _createClass(PullRequestList, [{
                key: 'getKeyboardAction',
                value: function getKeyboardAction(action) {
                    var kbdAction = this._keyboardActions[action];
                    if (typeof kbdAction === 'function') {
                        return kbdAction;
                    }
                    throw new Error('No keyboard action has been defined for \'' + action + '\'.');
                }
            }, {
                key: '_keyboardActions',
                get: function get() {
                    return {
                        moveNext: this.pullRequestTable.moveNext,
                        movePrevious: this.pullRequestTable.movePrevious,
                        openItem: this.pullRequestTable.openItem
                    };
                }
            }]);

            return PullRequestList;
        }(_widget2.default);

        exports.default = PullRequestList;
        module.exports = exports['default'];
    }
);